/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.canova.api.split.BaseInputSplit;

public class FileSplit
extends BaseInputSplit {
    private File rootDir;

    public FileSplit(File rootDir) {
        if (rootDir == null && rootDir.exists()) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.rootDir = rootDir;
        if (rootDir.isDirectory()) {
            Collection subFiles = FileUtils.listFiles((File)rootDir, null, (boolean)true);
            this.locations = new URI[subFiles.size()];
            int count = 0;
            for (File f : subFiles) {
                this.locations[count++] = f.getPath().startsWith("file:") ? URI.create(f.getPath()) : f.toURI();
                this.length += f.length();
            }
        } else {
            String path = rootDir.getPath();
            this.locations = new URI[1];
            this.locations[0] = path.startsWith("file:") ? URI.create(path) : rootDir.toURI();
            this.length += rootDir.length();
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

