/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import org.canova.api.split.InputSplit;

public class NumberedFileInputSplit
implements InputSplit {
    private final String baseString;
    private final int minIdx;
    private final int maxIdx;

    public NumberedFileInputSplit(String baseString, int minIdxInclusive, int maxIdxInclusive) {
        if (baseString == null || !baseString.contains("%d")) {
            throw new IllegalArgumentException("Base String must contain  character sequence %d");
        }
        this.baseString = baseString;
        this.minIdx = minIdxInclusive;
        this.maxIdx = maxIdxInclusive;
    }

    @Override
    public long length() {
        return this.maxIdx - this.minIdx + 1;
    }

    @Override
    public URI[] locations() {
        URI[] uris = new URI[(int)this.length()];
        int x = 0;
        for (int i = this.minIdx; i <= this.maxIdx; ++i) {
            uris[x++] = Paths.get(String.format(this.baseString, i), new String[0]).toUri();
        }
        return uris;
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    @Override
    public double toDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float toFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }
}

