/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.random.RandomGenerator;
import org.canova.api.berkeley.Counter;
import org.canova.api.util.SetUtils;

public class MathUtils {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static double normalize(double val, double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("Max must be greather than min");
        }
        return (val - min) / (max - min);
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static int discretize(double value, double min, double max, int binCount) {
        int discreteValue = (int)((double)binCount * MathUtils.normalize(value, min, max));
        return MathUtils.clamp(discreteValue, 0, binCount - 1);
    }

    public static long nextPowOf2(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static int binomial(RandomGenerator rng, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            return 0;
        }
        int c = 0;
        for (int i = 0; i < n; ++i) {
            if (!(rng.nextDouble() < p)) continue;
            ++c;
        }
        return c;
    }

    public static double uniform(Random rng, double min, double max) {
        return rng.nextDouble() * (max - min) + min;
    }

    public static double correlation(double[] residuals, double[] targetAttribute) {
        double[] predictedValues = new double[residuals.length];
        for (int i = 0; i < predictedValues.length; ++i) {
            predictedValues[i] = targetAttribute[i] - residuals[i];
        }
        double ssErr = MathUtils.ssError(predictedValues, targetAttribute);
        double total = MathUtils.ssTotal(residuals, targetAttribute);
        return 1.0 - ssErr / total;
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -x));
    }

    public static double ssReg(double[] residuals, double[] targetAttribute) {
        double mean = MathUtils.sum(targetAttribute) / (double)targetAttribute.length;
        double ret = 0.0;
        for (int i = 0; i < residuals.length; ++i) {
            ret += Math.pow(residuals[i] - mean, 2.0);
        }
        return ret;
    }

    public static double ssError(double[] predictedValues, double[] targetAttribute) {
        double ret = 0.0;
        for (int i = 0; i < predictedValues.length; ++i) {
            ret += Math.pow(targetAttribute[i] - predictedValues[i], 2.0);
        }
        return ret;
    }

    public static double stringSimilarity(String ... strings) {
        int i;
        if (strings == null) {
            return 0.0;
        }
        Counter<String> counter = new Counter<String>();
        Counter<String> counter2 = new Counter<String>();
        for (i = 0; i < strings[0].length(); ++i) {
            counter.incrementCount(String.valueOf(strings[0].charAt(i)), 1.0);
        }
        for (i = 0; i < strings[1].length(); ++i) {
            counter2.incrementCount(String.valueOf(strings[1].charAt(i)), 1.0);
        }
        Set v1 = counter.keySet();
        Set v2 = counter2.keySet();
        Set<String> both = SetUtils.intersection(v1, v2);
        double scalar = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (String k : both) {
            scalar += counter.getCount(k) * counter2.getCount(k);
        }
        for (String k : v1) {
            norm1 += counter.getCount(k) * counter.getCount(k);
        }
        for (String k : v2) {
            norm2 += counter2.getCount(k) * counter2.getCount(k);
        }
        return scalar / Math.sqrt(norm1 * norm2);
    }

    public static double vectorLength(double[] vector) {
        double ret = 0.0;
        if (vector == null) {
            return ret;
        }
        for (double aVector : vector) {
            ret += Math.pow(aVector, 2.0);
        }
        return ret;
    }

    public static double idf(double totalDocs, double numTimesWordAppearedInADocument) {
        return totalDocs > 0.0 ? Math.log10(totalDocs / numTimesWordAppearedInADocument) : 0.0;
    }

    public static double tf(int count) {
        return count > 0 ? 1.0 + Math.log10(count) : 0.0;
    }

    public static double tfidf(double td, double idf) {
        return td * idf;
    }

    private static int charForLetter(char c) {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static double ssTotal(double[] residuals, double[] targetAttribute) {
        return MathUtils.ssReg(residuals, targetAttribute) + MathUtils.ssError(residuals, targetAttribute);
    }

    public static double sum(double[] nums) {
        double ret = 0.0;
        for (double d : nums) {
            ret += d;
        }
        return ret;
    }

    public static double[] mergeCoords(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Sample sizes must be the same for each data applyTransformToDestination.");
        }
        double[] ret = new double[x.length + y.length];
        for (int i = 0; i < x.length; ++i) {
            ret[i] = x[i];
            ret[i + 1] = y[i];
        }
        return ret;
    }

    public static List<Double> mergeCoords(List<Double> x, List<Double> y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Sample sizes must be the same for each data applyTransformToDestination.");
        }
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 0; i < x.size(); ++i) {
            ret.add(x.get(i));
            ret.add(y.get(i));
        }
        return ret;
    }

    public static double[] weightsFor(List<Double> vector) {
        List<double[]> coords = MathUtils.coordSplit(vector);
        double[] x = coords.get(0);
        double[] y = coords.get(1);
        double meanX = MathUtils.sum(x) / (double)x.length;
        double meanY = MathUtils.sum(y) / (double)y.length;
        double sumOfMeanDifferences = MathUtils.sumOfMeanDifferences(x, y);
        double xDifferenceOfMean = MathUtils.sumOfMeanDifferencesOnePoint(x);
        double w_1 = sumOfMeanDifferences / xDifferenceOfMean;
        double w_0 = meanY - w_1 * meanX;
        double[] ret = new double[vector.size()];
        ret[0] = w_0;
        ret[1] = w_1;
        return ret;
    }

    public static double squaredLoss(double[] x, double[] y, double w_0, double w_1) {
        double sum = 0.0;
        for (int j = 0; j < x.length; ++j) {
            sum += Math.pow(y[j] - (w_1 * x[j] + w_0), 2.0);
        }
        return sum;
    }

    public static double w_1(double[] x, double[] y, int n) {
        return ((double)n * MathUtils.sumOfProducts(x, y) - MathUtils.sum(x) * MathUtils.sum(y)) / ((double)n * MathUtils.sumOfSquares(x) - Math.pow(MathUtils.sum(x), 2.0));
    }

    public static double w_0(double[] x, double[] y, int n) {
        double weight1 = MathUtils.w_1(x, y, n);
        return (MathUtils.sum(y) - weight1 * MathUtils.sum(x)) / (double)n;
    }

    public static double[] weightsFor(double[] vector) {
        List<double[]> coords = MathUtils.coordSplit(vector);
        double[] x = coords.get(0);
        double[] y = coords.get(1);
        double meanX = MathUtils.sum(x) / (double)x.length;
        double meanY = MathUtils.sum(y) / (double)y.length;
        double sumOfMeanDifferences = MathUtils.sumOfMeanDifferences(x, y);
        double xDifferenceOfMean = MathUtils.sumOfMeanDifferencesOnePoint(x);
        double w_1 = sumOfMeanDifferences / xDifferenceOfMean;
        double w_0 = meanY - w_1 * meanX;
        double[] ret = new double[vector.length];
        ret[0] = w_0;
        ret[1] = w_1;
        return ret;
    }

    public static double errorFor(double actual, double prediction) {
        return actual - prediction;
    }

    public static double sumOfMeanDifferences(double[] vector, double[] vector2) {
        double mean = MathUtils.sum(vector) / (double)vector.length;
        double mean2 = MathUtils.sum(vector2) / (double)vector2.length;
        double ret = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            double vec1Diff = vector[i] - mean;
            double vec2Diff = vector2[i] - mean2;
            ret += vec1Diff * vec2Diff;
        }
        return ret;
    }

    public static double sumOfMeanDifferencesOnePoint(double[] vector) {
        double mean = MathUtils.sum(vector) / (double)vector.length;
        double ret = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            double vec1Diff = Math.pow(vector[i] - mean, 2.0);
            ret += vec1Diff;
        }
        return ret;
    }

    public static double times(double[] nums) {
        if (nums == null || nums.length == 0) {
            return 0.0;
        }
        double ret = 1.0;
        for (double num : nums) {
            ret *= num;
        }
        return ret;
    }

    public static double sumOfProducts(double[] ... nums) {
        if (nums == null || nums.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < nums.length; ++i) {
            double[] column = MathUtils.column(i, nums);
            sum += MathUtils.times(column);
        }
        return sum;
    }

    private static double[] column(int column, double[] ... nums) throws IllegalArgumentException {
        double[] ret = new double[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            double[] curr = nums[i];
            ret[i] = curr[column];
        }
        return ret;
    }

    public static List<double[]> coordSplit(double[] vector) {
        if (vector == null) {
            return null;
        }
        ArrayList<double[]> ret = new ArrayList<double[]>();
        double[] xVals = new double[vector.length / 2];
        double[] yVals = new double[vector.length / 2];
        int xTracker = 0;
        int yTracker = 0;
        for (int i = 0; i < vector.length; ++i) {
            if (i % 2 == 0) {
                xVals[xTracker++] = vector[i];
                continue;
            }
            yVals[yTracker++] = vector[i];
        }
        ret.add(xVals);
        ret.add(yVals);
        return ret;
    }

    public static List<List<Double>> partitionVariable(List<Double> arr, int chunk) {
        ArrayList<List<Double>> ret = new ArrayList<List<Double>>();
        for (int count = 0; count < arr.size(); count += chunk) {
            List<Double> sublist = arr.subList(count, count + chunk);
            ret.add(sublist);
        }
        for (List list : ret) {
            if (list.size() >= chunk) continue;
            ret.remove(list);
        }
        return ret;
    }

    public static List<double[]> coordSplit(List<Double> vector) {
        if (vector == null) {
            return null;
        }
        ArrayList<double[]> ret = new ArrayList<double[]>();
        double[] xVals = new double[vector.size() / 2];
        double[] yVals = new double[vector.size() / 2];
        int xTracker = 0;
        int yTracker = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if (i % 2 == 0) {
                xVals[xTracker++] = vector.get(i);
                continue;
            }
            yVals[yTracker++] = vector.get(i);
        }
        ret.add(xVals);
        ret.add(yVals);
        return ret;
    }

    public static double[] xVals(double[] vector) {
        if (vector == null) {
            return null;
        }
        double[] x = new double[vector.length / 2];
        int count = 0;
        for (int i = 0; i < vector.length; ++i) {
            if (i % 2 == 0) continue;
            x[count++] = vector[i];
        }
        return x;
    }

    public static double[] yVals(double[] vector) {
        double[] y = new double[vector.length / 2];
        int count = 0;
        for (int i = 0; i < vector.length; ++i) {
            if (i % 2 != 0) continue;
            y[count++] = vector[i];
        }
        return y;
    }

    public static double sumOfSquares(double[] vector) {
        double ret = 0.0;
        for (double d : vector) {
            ret += Math.pow(d, 2.0);
        }
        return ret;
    }

    public static double determinationCoefficient(double[] y1, double[] y2, int n) {
        return Math.pow(MathUtils.correlation(y1, y2), 2.0);
    }

    public static double log2(double a) {
        if (a == 0.0) {
            return 0.0;
        }
        return Math.log(a) / log2;
    }

    public double slope(double x1, double x2, double y1, double y2) {
        return (y2 - y1) / (x2 - x1);
    }

    public static double rootMeansSquaredError(double[] real, double[] predicted) {
        double ret = 1 / real.length;
        for (int i = 0; i < real.length; ++i) {
            ret += Math.pow(real[i] - predicted[i], 2.0);
        }
        return Math.sqrt(ret);
    }

    public static double entropy(double[] vector) {
        if (vector == null) {
            return 0.0;
        }
        if (vector.length < 1) {
            return 0.0;
        }
        double ret = 0.0;
        for (double d : vector) {
            ret += d * Math.log(d);
        }
        return ret;
    }

    public static int kroneckerDelta(double i, double j) {
        return i == j ? 1 : 0;
    }

    public static double adjustedrSquared(double rSquared, int numRegressors, int numDataPoints) {
        double divide = (numDataPoints - 1) / (numDataPoints - numRegressors - 1);
        double rSquaredDiff = 1.0 - rSquared;
        return 1.0 - rSquaredDiff * divide;
    }

    public static double[] normalizeToOne(double[] doubles) {
        MathUtils.normalize(doubles, MathUtils.sum(doubles));
        return doubles;
    }

    public static double min(double[] doubles) {
        double ret = doubles[0];
        for (double d : doubles) {
            if (!(d < ret)) continue;
            ret = d;
        }
        return ret;
    }

    public static double max(double[] doubles) {
        double ret = doubles[0];
        for (double d : doubles) {
            if (!(d > ret)) continue;
            ret = d;
        }
        return ret;
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Can't normalize array. Sum is zero.");
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static double[] logs2probs(double[] a) {
        double max = a[MathUtils.maxIndex(a)];
        double sum = 0.0;
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.exp(a[i] - max);
            sum += result[i];
        }
        MathUtils.normalize(result, sum);
        return result;
    }

    public static double information(double[] probabilities) {
        double total = 0.0;
        for (double d : probabilities) {
            total += -1.0 * MathUtils.log2(d) * d;
        }
        return total;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public static double factorial(double n) {
        if (n == 1.0 || n == 0.0) {
            return 1.0;
        }
        double i = n;
        while (i > 0.0) {
            n *= (i -= 1.0) > 0.0 ? i : 1.0;
        }
        return n;
    }

    public static double probToLogOdds(double prob) {
        if (MathUtils.gr(prob, 1.0) || MathUtils.sm(prob, 0.0)) {
            throw new IllegalArgumentException("probToLogOdds: probability must be in [0,1] " + prob);
        }
        double p = SMALL + (1.0 - 2.0 * SMALL) * prob;
        return Math.log(p / (1.0 - p));
    }

    public static int round(double value) {
        return value > 0.0 ? (int)(value + 0.5) : -((int)(Math.abs(value) + 0.5));
    }

    public static double permutation(double n, double r) {
        double nFac = MathUtils.factorial(n);
        double nMinusRFac = MathUtils.factorial(n - r);
        return nFac / nMinusRFac;
    }

    public static double combination(double n, double r) {
        double nFac = MathUtils.factorial(n);
        double rFac = MathUtils.factorial(r);
        double nMinusRFac = MathUtils.factorial(n - r);
        return nFac / (rFac * nMinusRFac);
    }

    public static double hypotenuse(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static int probRound(double value, Random rand) {
        if (value >= 0.0) {
            double lower = Math.floor(value);
            double prob = value - lower;
            if (rand.nextDouble() < prob) {
                return (int)lower + 1;
            }
            return (int)lower;
        }
        double lower = Math.floor(Math.abs(value));
        double prob = Math.abs(value) - lower;
        if (rand.nextDouble() < prob) {
            return -((int)lower + 1);
        }
        return -((int)lower);
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static float roundFloat(float value, int afterDecimalPoint) {
        float mask = (float)Math.pow(10.0, afterDecimalPoint);
        return (float)Math.round(value * mask) / mask;
    }

    public static double bernoullis(double n, double k, double successProb) {
        double combo = MathUtils.combination(n, k);
        double q = 1.0 - successProb;
        return combo * Math.pow(successProb, k) * Math.pow(q, n - k);
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static double[] fromString(String data, String separator) {
        String[] split = data.split(separator);
        double[] ret = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            ret[i] = Double.parseDouble(split[i]);
        }
        return ret;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        if (vector.length == 0) {
            return 0.0;
        }
        for (double aVector : vector) {
            sum += aVector;
        }
        return sum / (double)vector.length;
    }

    public static int toDecimal(String binary) {
        for (long num = Long.parseLong(binary); num > 0L; num /= 10L) {
            long rem = num % 10L;
            if (rem == 0L || rem == 1L) continue;
            System.out.println("This is not a binary number.");
            System.out.println("Please try once again.");
            return -1;
        }
        return Integer.parseInt(binary, 2);
    }

    public static int distanceFinderZValue(double[] vector) {
        StringBuilder binaryBuffer = new StringBuilder();
        ArrayList<String> binaryReps = new ArrayList<String>(vector.length);
        for (double d : vector) {
            int j = (int)d;
            String binary = Integer.toBinaryString(j);
            binaryReps.add(binary);
        }
        while (!binaryReps.isEmpty()) {
            for (int j = 0; j < binaryReps.size(); ++j) {
                String curr = (String)binaryReps.get(j);
                if (!curr.isEmpty()) {
                    char first = curr.charAt(0);
                    binaryBuffer.append(first);
                    curr = curr.substring(1);
                    binaryReps.set(j, curr);
                    continue;
                }
                binaryReps.remove(j);
            }
        }
        return Integer.parseInt(binaryBuffer.toString(), 2);
    }

    public static double euclideanDistance(double[] p, double[] q) {
        double ret = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double diff = q[i] - p[i];
            double sq = Math.pow(diff, 2.0);
            ret += sq;
        }
        return ret;
    }

    public static double euclideanDistance(float[] p, float[] q) {
        double ret = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double diff = q[i] - p[i];
            double sq = Math.pow(diff, 2.0);
            ret += sq;
        }
        return ret;
    }

    public static double[] generateUniform(int l) {
        double[] ret = new double[l];
        Random rgen = new Random();
        for (int i = 0; i < l; ++i) {
            ret[i] = rgen.nextDouble();
        }
        return ret;
    }

    public static double manhattanDistance(double[] p, double[] q) {
        double ret = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double difference = p[i] - q[i];
            ret += Math.abs(difference);
        }
        return ret;
    }

    public static double[] sampleDoublesInInterval(double[][] doubles, int l) {
        double[] sample = new double[l];
        for (int i = 0; i < l; ++i) {
            int rand1 = MathUtils.randomNumberBetween(0.0, doubles.length - 1);
            int rand2 = MathUtils.randomNumberBetween(0.0, doubles[i].length);
            sample[i] = doubles[rand1][rand2];
        }
        return sample;
    }

    public static int randomNumberBetween(double begin, double end) {
        if (begin > end) {
            throw new IllegalArgumentException("Begin must not be less than end");
        }
        return (int)begin + (int)(Math.random() * (end - begin + 1.0));
    }

    public static int randomNumberBetween(double begin, double end, RandomGenerator rng) {
        if (begin > end) {
            throw new IllegalArgumentException("Begin must not be less than end");
        }
        return (int)begin + (int)(rng.nextDouble() * (end - begin + 1.0));
    }

    public static float randomFloatBetween(float begin, float end) {
        float rand = (float)Math.random();
        return begin + rand * (end - begin);
    }

    public static double randomDoubleBetween(double begin, double end) {
        return begin + Math.random() * (end - begin);
    }
}

