/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.canova.api.conf.Configurable;
import org.canova.api.conf.Configuration;
import org.canova.api.io.DataInputBuffer;
import org.canova.api.io.DataOutputBuffer;
import org.canova.api.io.serializers.Deserializer;
import org.canova.api.io.serializers.SerializationFactory;
import org.canova.api.io.serializers.Serializer;
import org.canova.api.writable.Writable;

public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static SerializationFactory serialFactory = null;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static long previousLogTime = 0L;
    private static ThreadLocal<CopyInCopyOutBuffer> cloneBuffers = new ThreadLocal<CopyInCopyOutBuffer>(){

        @Override
        protected synchronized CopyInCopyOutBuffer initialValue() {
            return new CopyInCopyOutBuffer();
        }
    };

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                ((Configurable)theObject).setConf(conf);
            }
            ReflectionUtils.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        try {
            Class<?> jobConfClass = conf.getClassByName("org.apache.hadoop.mapred.JobConf");
            Class<?> jobConfigurableClass = conf.getClassByName("org.apache.hadoop.mapred.JobConfigurable");
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                Method configureMethod = jobConfigurableClass.getMethod("configure", jobConfClass);
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result, conf);
        return (T)result;
    }

    public static void setContentionTracing(boolean val) {
        threadBean.setThreadContentionMonitoringEnabled(val);
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static void printThreadInfo(PrintWriter stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ReflectionUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ReflectionUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    public static <T> Class<T> getClass(T o) {
        return o.getClass();
    }

    static void clearCache() {
        CONSTRUCTOR_CACHE.clear();
    }

    static int getCacheSize() {
        return CONSTRUCTOR_CACHE.size();
    }

    private static SerializationFactory getFactory(Configuration conf) {
        if (serialFactory == null) {
            serialFactory = new SerializationFactory(conf);
        }
        return serialFactory;
    }

    public static <T> T copy(Configuration conf, T src, T dst) throws IOException {
        CopyInCopyOutBuffer buffer = cloneBuffers.get();
        buffer.outBuffer.reset();
        SerializationFactory factory = ReflectionUtils.getFactory(conf);
        Class<?> cls = src.getClass();
        Serializer<?> serializer = factory.getSerializer(cls);
        serializer.open(buffer.outBuffer);
        serializer.serialize(src);
        buffer.moveData();
        Deserializer<?> deserializer = factory.getDeserializer(cls);
        deserializer.open(buffer.inBuffer);
        dst = deserializer.deserialize(dst);
        return dst;
    }

    @Deprecated
    public static void cloneWritableInto(Writable dst, Writable src) throws IOException {
        CopyInCopyOutBuffer buffer = cloneBuffers.get();
        buffer.outBuffer.reset();
        src.write(buffer.outBuffer);
        buffer.moveData();
        dst.readFields(buffer.inBuffer);
    }

    private static class CopyInCopyOutBuffer {
        DataOutputBuffer outBuffer = new DataOutputBuffer();
        DataInputBuffer inBuffer = new DataInputBuffer();

        private CopyInCopyOutBuffer() {
        }

        void moveData() {
            this.inBuffer.reset(this.outBuffer.getData(), this.outBuffer.getLength());
        }
    }
}

