/*
 *
 *  *
 *  *  * Copyright 2015 Skymind,Inc.
 *  *  *
 *  *  *    Licensed under the Apache License, Version 2.0 (the "License");
 *  *  *    you may not use this file except in compliance with the License.
 *  *  *    You may obtain a copy of the License at
 *  *  *
 *  *  *        http://www.apache.org/licenses/LICENSE-2.0
 *  *  *
 *  *  *    Unless required by applicable law or agreed to in writing, software
 *  *  *    distributed under the License is distributed on an "AS IS" BASIS,
 *  *  *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *  *    See the License for the specific language governing permissions and
 *  *  *    limitations under the License.
 *  *
 *
 */

package org.canova.api.records.reader.factory;

import org.canova.api.exceptions.UnknownFormatException;
import org.canova.api.records.reader.RecordReader;

import java.net.URI;

/**
 * Factory for creating RecordReader instance
 *
 * @author sonali
 */
public interface RecordReaderFactory {
    /**
     * Creates instance of RecordReader
     *
     * @param uri
     * @return record reader instance
     * @throws UnknownFormatException
     */
    RecordReader create(URI uri) throws UnknownFormatException;
}
