/*
 *
 *  *
 *  *  * Copyright 2015 Skymind,Inc.
 *  *  *
 *  *  *    Licensed under the Apache License, Version 2.0 (the "License");
 *  *  *    you may not use this file except in compliance with the License.
 *  *  *    You may obtain a copy of the License at
 *  *  *
 *  *  *        http://www.apache.org/licenses/LICENSE-2.0
 *  *  *
 *  *  *    Unless required by applicable law or agreed to in writing, software
 *  *  *    distributed under the License is distributed on an "AS IS" BASIS,
 *  *  *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *  *    See the License for the specific language governing permissions and
 *  *  *    limitations under the License.
 *  *
 *
 */

package org.canova.api.records.writer.impl;


import org.canova.api.conf.Configuration;
import org.canova.api.writable.Writable;

import java.io.*;
import java.util.Collection;

/**
 * Csv record writer
 *
 * @author Adam Gibson
 */
public class CSVRecordWriter extends FileRecordWriter {

    public CSVRecordWriter() {
    }

    public CSVRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public CSVRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public CSVRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        if(!record.isEmpty()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for(Writable w : record) {
                w.write(dos);
                dos.write(NEW_LINE.getBytes());
            }

            dos.flush();
            dos.close();
        }

    }
}
