/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.io.labels;

import java.io.File;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.canova.api.io.data.Text;
import org.canova.api.io.labels.PathLabelGenerator;
import org.canova.api.writable.Writable;

public class PatternPathLabelGenerator
implements PathLabelGenerator {
    protected String pattern;
    protected int patternPosition = 0;

    public PatternPathLabelGenerator(String pattern, int patternPosition) {
        this.pattern = pattern;
        this.patternPosition = patternPosition;
    }

    @Override
    public Writable getLabelForPath(String path) {
        return new Text(FilenameUtils.getBaseName((String)path).split(this.pattern)[this.patternPosition]);
    }

    @Override
    public Writable getLabelForPath(URI uri) {
        return this.getLabelForPath(new File(uri).toString());
    }
}

