/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.impl.LineRecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;

public class CSVRecordReader
extends LineRecordReader {
    private boolean skippedLines = false;
    private int skipNumLines = 0;
    private String delimiter = ",";
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    public static final String DELIMITER = NAME_SPACE + ".delimiter";

    public CSVRecordReader(int skipNumLines) {
        this(skipNumLines, ",");
    }

    public CSVRecordReader(int skipNumLines, String delimiter) {
        this.skipNumLines = skipNumLines;
        this.delimiter = delimiter;
    }

    public CSVRecordReader() {
        this(0, ",");
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
        this.delimiter = conf.get(DELIMITER, ",");
    }

    @Override
    public Collection<Writable> next() {
        if (!this.skippedLines && this.skipNumLines > 0) {
            for (int i = 0; i < this.skipNumLines; ++i) {
                if (!this.hasNext()) {
                    return new ArrayList<Writable>();
                }
                super.next();
            }
            this.skippedLines = true;
        }
        Text t = (Text)super.next().iterator().next();
        String val = t.toString();
        String[] split = val.split(this.delimiter, -1);
        ArrayList<Writable> ret = new ArrayList<Writable>();
        for (String s : split) {
            ret.add(new Text(s));
        }
        return ret;
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading CSV data from DataInputStream not yet implemented");
    }
}

