/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl.regex;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.SequenceRecordReader;
import org.canova.api.records.reader.impl.FileRecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexSequenceRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final LineErrorHandling DEFAULT_ERROR_HANDLING = LineErrorHandling.FailOnInvalid;
    public static final Logger LOG = LoggerFactory.getLogger(RegexSequenceRecordReader.class);
    private String regex;
    private int skipNumLines;
    private Pattern pattern;
    private Charset charset;
    private LineErrorHandling errorHandling;

    public RegexSequenceRecordReader(String regex, int skipNumLines) {
        this(regex, skipNumLines, DEFAULT_CHARSET, DEFAULT_ERROR_HANDLING);
    }

    public RegexSequenceRecordReader(String regex, int skipNumLines, Charset encoding, LineErrorHandling errorHandling) {
        this.regex = regex;
        this.skipNumLines = skipNumLines;
        this.pattern = Pattern.compile(regex);
        this.charset = encoding;
        this.errorHandling = errorHandling;
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
    }

    @Override
    public Collection<Collection<Writable>> sequenceRecord() {
        String fileContents;
        File next = (File)this.iter.next();
        try {
            fileContents = FileUtils.readFileToString((File)next, (String)this.charset.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.loadSequence(fileContents, next.toURI());
    }

    @Override
    public Collection<Collection<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        String fileContents = IOUtils.toString((InputStream)dataInputStream, (String)this.charset.name());
        return this.loadSequence(fileContents, uri);
    }

    private Collection<Collection<Writable>> loadSequence(String fileContents, URI uri) {
        String[] lines = fileContents.split("(\r\n)|\n");
        int numLinesSkipped = 0;
        ArrayList<Collection<Writable>> out = new ArrayList<Collection<Writable>>();
        int lineCount = 0;
        block5: for (String line : lines) {
            ArrayList<Text> timeStep;
            ++lineCount;
            if (numLinesSkipped < this.skipNumLines) {
                ++numLinesSkipped;
                continue;
            }
            Matcher m = this.pattern.matcher(line);
            if (m.matches()) {
                int count = m.groupCount();
                timeStep = new ArrayList<Text>(count);
                for (int i = 1; i <= count; ++i) {
                    timeStep.add(new Text(m.group(i)));
                }
            } else {
                switch (this.errorHandling) {
                    case FailOnInvalid: {
                        throw new IllegalStateException("Invalid line: line does not match regex (line #" + lineCount + ", uri=\"" + uri + "\"), " + "\", regex=" + this.regex + "\"; line=\"" + line + "\"");
                    }
                    case SkipInvalid: {
                        continue block5;
                    }
                    case SkipInvalidWithWarning: {
                        String warnMsg = "Skipping invalid line: line does not match regex (line #" + lineCount + ", uri=\"" + uri + "\"), " + "\"; line=\"" + line + "\"";
                        LOG.warn(warnMsg);
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Unknown error handling mode: " + (Object)((Object)this.errorHandling));
                    }
                }
            }
            out.add(timeStep);
        }
        return out;
    }

    @Override
    public void reset() {
        super.reset();
    }

    public static enum LineErrorHandling {
        FailOnInvalid,
        SkipInvalid,
        SkipInvalidWithWarning;

    }
}

