/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.writer.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.writer.RecordWriter;
import org.canova.api.writable.Writable;

public class FileRecordWriter
implements RecordWriter {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected File writeTo;
    protected DataOutputStream out;
    public static final String NEW_LINE = "\n";
    private boolean append;
    public static final String PATH = "org.canova.api.records.writer.path";
    protected Charset encoding = DEFAULT_CHARSET;
    protected Configuration conf;

    public FileRecordWriter() {
    }

    public FileRecordWriter(File path) throws FileNotFoundException {
        this(path, false, DEFAULT_CHARSET);
    }

    public FileRecordWriter(File path, boolean append) throws FileNotFoundException {
        this(path, append, DEFAULT_CHARSET);
    }

    public FileRecordWriter(File path, boolean append, Charset encoding) throws FileNotFoundException {
        this.writeTo = path;
        this.append = append;
        this.encoding = encoding;
        this.out = new DataOutputStream(new FileOutputStream(this.writeTo, append));
    }

    public FileRecordWriter(Configuration conf) throws FileNotFoundException {
        this.setConf(conf);
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            Text t = (Text)record.iterator().next();
            t.write(this.out);
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.writeTo = new File(conf.get(PATH, "input.txt"));
        this.append = conf.getBoolean("org.canova.api.record.writer.append", true);
        try {
            this.out = new DataOutputStream(new FileOutputStream(this.writeTo, this.append));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

