/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.writer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.canova.api.conf.Configuration;
import org.canova.api.records.writer.impl.FileRecordWriter;
import org.canova.api.writable.ArrayWritable;
import org.canova.api.writable.Writable;

public class SVMLightRecordWriter
extends FileRecordWriter {
    public SVMLightRecordWriter() {
    }

    public SVMLightRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public SVMLightRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public SVMLightRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            List<Object> recordList = record instanceof List ? (List<Object>)record : new ArrayList<Writable>(record);
            StringBuilder result = new StringBuilder();
            result.append(((Writable)recordList.get(recordList.size() - 1)).toString());
            Double value = 0.0;
            for (int i = 0; i < recordList.size() - 1; ++i) {
                try {
                    value = Double.valueOf(((Writable)recordList.get(i)).toString());
                    if (!(value > 0.0)) continue;
                    result.append(" " + (i + 1) + ":" + Double.valueOf(((Writable)recordList.get(i)).toString()));
                    continue;
                }
                catch (NumberFormatException e) {
                    Writable w = (Writable)recordList.get(i);
                    if (w instanceof ArrayWritable) {
                        ArrayWritable a = (ArrayWritable)w;
                        for (long j = 0L; j < a.length(); ++j) {
                            value = a.getDouble(j);
                            if (!(value > 0.0)) continue;
                            result.append(" " + (j + 1L) + ":" + value);
                        }
                        continue;
                    }
                    throw e;
                }
            }
            this.out.write(result.toString().getBytes());
            this.out.write("\n".getBytes());
        }
    }
}

