/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.io.filters;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.canova.api.io.filters.RandomPathFilter;
import org.canova.api.io.labels.PathLabelGenerator;
import org.canova.api.writable.Writable;

public class BalancedPathFilter
extends RandomPathFilter {
    protected PathLabelGenerator labelGenerator;
    protected int maxLabels = 0;
    protected int minPathsPerLabel = 0;
    protected int maxPathsPerLabel = 0;
    protected String[] labels = null;

    public BalancedPathFilter(Random random, String[] extensions, PathLabelGenerator labelGenerator) {
        this(random, extensions, labelGenerator, 0, 0, 0, 0, new String[0]);
    }

    public BalancedPathFilter(Random random, PathLabelGenerator labelGenerator, int maxPathsPerLabel) {
        this(random, null, labelGenerator, 0, 0, 0, maxPathsPerLabel, new String[0]);
    }

    public BalancedPathFilter(Random random, String[] extensions, PathLabelGenerator labelGenerator, int maxPathsPerLabel) {
        this(random, extensions, labelGenerator, 0, 0, 0, maxPathsPerLabel, new String[0]);
    }

    public BalancedPathFilter(Random random, PathLabelGenerator labelGenerator, int maxPaths, int maxLabels, int maxPathsPerLabel) {
        this(random, null, labelGenerator, maxPaths, maxLabels, 0, maxPathsPerLabel, new String[0]);
    }

    public BalancedPathFilter(Random random, String[] extensions, PathLabelGenerator labelGenerator, int maxLabels, int maxPathsPerLabel) {
        this(random, extensions, labelGenerator, 0, maxLabels, 0, maxPathsPerLabel, new String[0]);
    }

    public BalancedPathFilter(Random random, String[] extensions, PathLabelGenerator labelGenerator, int maxPaths, int maxLabels, int minPathsPerLabel, int maxPathsPerLabel, String ... labels) {
        super(random, extensions, maxPaths);
        this.labelGenerator = labelGenerator;
        this.maxLabels = maxLabels;
        this.minPathsPerLabel = minPathsPerLabel;
        this.maxPathsPerLabel = maxPathsPerLabel;
        this.labels = labels;
    }

    protected boolean acceptLabel(String name) {
        if (this.labels == null || this.labels.length == 0) {
            return true;
        }
        for (String label : this.labels) {
            if (!name.equals(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URI[] filter(URI[] paths) {
        paths = super.filter(paths);
        LinkedHashMap<Writable, ArrayList<Object>> labelPaths = new LinkedHashMap<Writable, ArrayList<Object>>();
        for (int i = 0; i < paths.length; ++i) {
            URI path = paths[i];
            Writable label = this.labelGenerator.getLabelForPath(path);
            if (!this.acceptLabel(label.toString())) continue;
            ArrayList<Object> pathList = (ArrayList<Object>)labelPaths.get(label);
            if (pathList == null) {
                if (this.maxLabels > 0 && labelPaths.size() >= this.maxLabels) continue;
                pathList = new ArrayList<Object>();
                labelPaths.put(label, pathList);
            }
            pathList.add(path);
        }
        int minCount = this.maxPathsPerLabel > 0 ? this.maxPathsPerLabel : Integer.MAX_VALUE;
        for (List pathList : labelPaths.values()) {
            if (minCount <= pathList.size()) continue;
            minCount = pathList.size();
        }
        if (minCount < this.minPathsPerLabel) {
            minCount = this.minPathsPerLabel;
        }
        ArrayList newpaths = new ArrayList();
        for (int i = 0; i < minCount; ++i) {
            for (List p : labelPaths.values()) {
                if (i >= p.size()) continue;
                newpaths.add(p.get(i));
            }
        }
        return newpaths.toArray(new URI[newpaths.size()]);
    }
}

