/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.io.serializers;

import java.util.ArrayList;
import java.util.List;
import org.canova.api.conf.Configuration;
import org.canova.api.conf.Configured;
import org.canova.api.io.serializers.Deserializer;
import org.canova.api.io.serializers.Serialization;
import org.canova.api.io.serializers.Serializer;
import org.canova.api.util.ReflectionUtils;
import org.canova.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFactory
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger((String)SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getStrings("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization")) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializationClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization<?>)ReflectionUtils.newInstance(serializationClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Serialization class not found: " + StringUtils.stringifyException(e));
        }
    }

    public <T> Serializer<T> getSerializer(Class<T> c) {
        return this.getSerialization(c).getSerializer(c);
    }

    public <T> Deserializer<T> getDeserializer(Class<T> c) {
        return this.getSerialization(c).getDeserializer(c);
    }

    public <T> Serialization<T> getSerialization(Class<T> c) {
        for (Serialization<T> serialization : this.serializations) {
            if (!serialization.accept(c)) continue;
            return serialization;
        }
        return null;
    }
}

