/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.BaseRecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.split.ListStringSplit;
import org.canova.api.writable.Writable;

public class ListStringRecordReader
extends BaseRecordReader {
    private List<List<String>> delimitedData;
    private Iterator<List<String>> dataIter;
    private Configuration conf;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (!(split instanceof ListStringSplit)) {
            throw new IllegalArgumentException("Illegal type of input split " + split.getClass().getName());
        }
        ListStringSplit listStringSplit = (ListStringSplit)split;
        this.delimitedData = listStringSplit.getData();
        this.dataIter = this.delimitedData.iterator();
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public Collection<Writable> next() {
        List<String> next = this.dataIter.next();
        this.invokeListeners(next);
        ArrayList<Writable> ret = new ArrayList<Writable>();
        for (String s : next) {
            ret.add(new Text(s));
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.dataIter.hasNext();
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void reset() {
        this.dataIter = this.delimitedData.iterator();
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

