/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.split;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.canova.api.split.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LimitFileSplit
extends FileSplit {
    protected static Logger log = LoggerFactory.getLogger(LimitFileSplit.class);
    protected int totalNumExamples;
    protected int numCategories;
    protected String pattern;
    protected int patternPosition = 0;

    public LimitFileSplit(File rootDir, String[] allowFormat, boolean recursive, int numExamples, int numCategories, String pattern, int patternPosition, Random random) {
        super(rootDir, allowFormat, recursive, random, false);
        this.totalNumExamples = numExamples;
        this.numCategories = numCategories;
        this.pattern = pattern;
        this.patternPosition = patternPosition;
        this.initialize();
    }

    public LimitFileSplit(File rootDir, int numExamples) {
        this(rootDir, null, true, numExamples, 1, null, 0, null);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, boolean recursive, int numExamples) {
        this(rootDir, allowFormat, recursive, numExamples, 1, null, 0, null);
    }

    public LimitFileSplit(File rootDir, int numExamples, String pattern) {
        this(rootDir, null, true, numExamples, 1, pattern, 0, null);
    }

    public LimitFileSplit(File rootDir, int numExamples, int numCategories, String pattern) {
        this(rootDir, null, true, numExamples, numCategories, pattern, 0, null);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, int numExamples, int numCategories, String pattern) {
        this(rootDir, allowFormat, true, numExamples, numCategories, pattern, 0, null);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, int numExamples, int numCategories, String pattern, int patternPosition, Random random) {
        this(rootDir, allowFormat, true, numExamples, numCategories, pattern, patternPosition, random);
    }

    public LimitFileSplit(File rootDir, int numExamples, Random random) {
        this(rootDir, null, true, numExamples, 1, null, 0, random);
    }

    public LimitFileSplit(File rootDir, int numExamples, String pattern, Random random) {
        this(rootDir, null, true, numExamples, 1, pattern, 0, random);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, int numExamples, int numCategories, String pattern, Random random) {
        this(rootDir, allowFormat, true, numExamples, numCategories, pattern, 0, random);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, int numExamples, String pattern, Random random) {
        this(rootDir, allowFormat, true, numExamples, 1, pattern, 0, random);
    }

    public LimitFileSplit(File rootDir, String[] allowFormat, int numExamples, String pattern, int patternPosition, Random random) {
        this(rootDir, allowFormat, true, numExamples, 1, pattern, patternPosition, random);
    }

    @Override
    protected void initialize() {
        Iterator iter = FileUtils.iterateFiles((File)this.rootDir, (String[])this.allowFormat, (boolean)this.recursive);
        ArrayList<File> subFiles = new ArrayList<File>();
        int numExamplesPerCategory = this.totalNumExamples >= this.numCategories ? this.totalNumExamples / this.numCategories + this.totalNumExamples % this.numCategories : 1;
        HashMap<String, Integer> fileCount = new HashMap<String, Integer>();
        String currName = "";
        int totalCount = 0;
        int numCategoryCount = 0;
        while (iter.hasNext() && numCategoryCount <= this.numCategories && totalCount < this.totalNumExamples) {
            File file = (File)iter.next();
            currName = this.pattern != null ? FilenameUtils.getBaseName((String)file.getName()).split(this.pattern)[this.patternPosition] : FilenameUtils.getBaseName((String)file.getParent());
            if (file.isFile()) {
                int categoryCount;
                if (!fileCount.containsKey(currName)) {
                    fileCount.put(currName, 0);
                    ++numCategoryCount;
                }
                if ((categoryCount = ((Integer)fileCount.get(currName)).intValue()) < numExamplesPerCategory) {
                    subFiles.add(file);
                    fileCount.put(currName, categoryCount + 1);
                    ++totalCount;
                }
            }
            if (numExamplesPerCategory != 0) continue;
            log.info("{} number of categories were loaded", (Object)fileCount.keySet().size());
        }
        this.locations = new URI[subFiles.size()];
        if (this.randomize) {
            Collections.shuffle((List)subFiles, this.random);
        }
        int count = 0;
        for (File f : subFiles) {
            this.locations[count++] = f.getPath().startsWith("file:") ? URI.create(f.getPath()) : f.toURI();
            this.length += f.length();
        }
    }
}

