/*
 * Decompiled with CFR 0.152.
 */
package org.canova.codec.reader;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.compress.utils.IOUtils;
import org.canova.api.conf.Configuration;
import org.canova.api.records.reader.SequenceRecordReader;
import org.canova.api.records.reader.impl.FileRecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;
import org.canova.common.RecordConverter;
import org.canova.image.loader.ImageLoader;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.common.ByteBufferSeekableByteChannel;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.nd4j.linalg.api.ndarray.INDArray;

public class CodecRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    private int startFrame = 0;
    private int numFrames = -1;
    private int totalFrames = -1;
    private double framesPerSecond = -1.0;
    private double videoLength = -1.0;
    private ImageLoader imageLoader;
    private boolean ravel = false;
    public static final String NAME_SPACE = "org.canova.codec.reader";
    public static final String ROWS = "org.canova.codec.reader.rows";
    public static final String COLUMNS = "org.canova.codec.reader.columns";
    public static final String START_FRAME = "org.canova.codec.reader.startframe";
    public static final String TOTAL_FRAMES = "org.canova.codec.reader.frames";
    public static final String TIME_SLICE = "org.canova.codec.reader.time";
    public static final String RAVEL = "org.canova.codec.reader.ravel";
    public static final String VIDEO_DURATION = "org.canova.codec.reader.duration";

    public Collection<Collection<Writable>> sequenceRecord() {
        File next = (File)this.iter.next();
        try {
            return this.loadData((SeekableByteChannel)NIOUtils.readableFileChannel((File)next));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Collection<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)dataInputStream);
        ByteBuffer bb = ByteBuffer.wrap(data);
        FixedByteBufferSeekableByteChannel sbc = new FixedByteBufferSeekableByteChannel(bb);
        return this.loadData((SeekableByteChannel)sbc);
    }

    private Collection<Collection<Writable>> loadData(SeekableByteChannel seekableByteChannel) throws IOException {
        ArrayList<Collection<Writable>> record = new ArrayList<Collection<Writable>>();
        if (this.numFrames >= 1) {
            FrameGrab fg;
            try {
                fg = new FrameGrab(seekableByteChannel);
                if (this.startFrame != 0) {
                    fg.seekToFramePrecise(this.startFrame);
                }
            }
            catch (JCodecException e) {
                throw new RuntimeException(e);
            }
            for (int i = this.startFrame; i < this.startFrame + this.numFrames; ++i) {
                try {
                    BufferedImage grab = fg.getFrame();
                    if (this.ravel) {
                        record.add(RecordConverter.toRecord((INDArray)this.imageLoader.toRaveledTensor(grab)));
                        continue;
                    }
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(grab)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (this.framesPerSecond < 1.0) {
                throw new IllegalStateException("No frames or frame time intervals specified");
            }
            for (double i = 0.0; i < this.videoLength; i += this.framesPerSecond) {
                try {
                    BufferedImage grab = FrameGrab.getFrame((SeekableByteChannel)seekableByteChannel, (double)i);
                    if (this.ravel) {
                        record.add(RecordConverter.toRecord((INDArray)this.imageLoader.toRaveledTensor(grab)));
                        continue;
                    }
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(grab)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return record;
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.setConf(conf);
        this.initialize(split);
    }

    public Collection<Writable> next() {
        throw new UnsupportedOperationException("next() not supported for CodecRecordReader (use: sequenceRecord)");
    }

    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("record(URI,DataInputStream) not supported for CodecRecordReader");
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.startFrame = conf.getInt(START_FRAME, 0);
        this.numFrames = conf.getInt(TOTAL_FRAMES, -1);
        int rows = conf.getInt(ROWS, 28);
        int cols = conf.getInt(COLUMNS, 28);
        this.imageLoader = new ImageLoader(rows, cols);
        this.framesPerSecond = conf.getFloat(TIME_SLICE, -1.0f);
        this.videoLength = conf.getFloat(VIDEO_DURATION, -1.0f);
        this.ravel = conf.getBoolean(RAVEL, false);
        this.totalFrames = conf.getInt(TOTAL_FRAMES, -1);
    }

    public Configuration getConf() {
        return super.getConf();
    }

    private static class FixedByteBufferSeekableByteChannel
    extends ByteBufferSeekableByteChannel {
        private ByteBuffer backing;

        public FixedByteBufferSeekableByteChannel(ByteBuffer backing) {
            super(backing);
            try {
                Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("maxPos");
                f.setAccessible(true);
                f.set((Object)this, backing.limit());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.backing = backing;
        }

        public int read(ByteBuffer dst) throws IOException {
            if (!this.backing.hasRemaining()) {
                return -1;
            }
            return super.read(dst);
        }
    }
}

