/*
 * Decompiled with CFR 0.152.
 */
package org.canova.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.canova.api.io.data.DoubleWritable;
import org.canova.api.io.data.FloatWritable;
import org.canova.api.writable.Writable;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class RecordConverter {
    private RecordConverter() {
    }

    public static INDArray toArray(Collection<Writable> record) {
        Iterator<Writable> writables = record.iterator();
        INDArray linear = Nd4j.zeros((int)record.size());
        int count = 0;
        while (writables.hasNext()) {
            linear.putScalar(count++, Double.valueOf(writables.next().toString()).doubleValue());
        }
        return linear;
    }

    public static Collection<Writable> toRecord(INDArray array) {
        INDArray linear = array.linearView();
        ArrayList<Writable> writables = new ArrayList<Writable>();
        for (int i = 0; i < linear.length(); ++i) {
            writables.add((Writable)(array.data().dataType() == DataBuffer.Type.DOUBLE ? new DoubleWritable(linear.getDouble(i)) : new FloatWritable(linear.getFloat(i))));
        }
        return writables;
    }
}

