/*
 * Decompiled with CFR 0.152.
 */
package org.canova.common.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.canova.api.io.WritableComparable;
import org.canova.api.io.WritableComparator;
import org.canova.api.writable.ArrayWritable;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class NDArrayWritable
extends ArrayWritable
implements WritableComparable {
    private INDArray array = null;

    public NDArrayWritable() {
    }

    public NDArrayWritable(INDArray array) {
        this.set(array);
    }

    public void readFields(DataInput in) throws IOException {
        long length = in.readLong();
        if (length == 0L) {
            this.array = null;
            return;
        }
        int type = in.readInt();
        if (this.array == null || (long)this.array.length() != length) {
            if (length >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Length can not be >= Integer.MAX_VALUE");
            }
            this.array = Nd4j.zeros((int)((int)length));
        }
        if (type == DataBuffer.Type.DOUBLE.ordinal()) {
            int i = 0;
            while ((long)i < length) {
                this.array.putScalar(i, in.readDouble());
                ++i;
            }
        } else if (type == DataBuffer.Type.FLOAT.ordinal()) {
            int i = 0;
            while ((long)i < length) {
                this.array.putScalar(i, in.readFloat());
                ++i;
            }
        } else if (type == DataBuffer.Type.INT.ordinal()) {
            int i = 0;
            while ((long)i < length) {
                this.array.putScalar(i, in.readInt());
                ++i;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + type);
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.array == null) {
            out.writeLong(0L);
            return;
        }
        DataBuffer data = this.array.data();
        DataBuffer.Type type = data.dataType();
        out.writeLong(this.array.length());
        out.writeInt(type.ordinal());
        switch (type) {
            case DOUBLE: {
                DoubleBuffer buffer = data.asNioDouble();
                while (buffer.remaining() > 0) {
                    out.writeDouble(buffer.get());
                }
                return;
            }
            case FLOAT: {
                FloatBuffer buffer = data.asNioFloat();
                while (buffer.remaining() > 0) {
                    out.writeFloat(buffer.get());
                }
                return;
            }
            case INT: {
                IntBuffer buffer = data.asNioInt();
                while (buffer.remaining() > 0) {
                    out.writeInt(buffer.get());
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public void set(INDArray array) {
        this.array = array;
    }

    public INDArray get() {
        return this.array;
    }

    public boolean equals(Object o) {
        DataBuffer.Type otherType;
        if (!(o instanceof NDArrayWritable)) {
            return false;
        }
        NDArrayWritable other = (NDArrayWritable)((Object)o);
        DataBuffer thisData = this.array.data();
        DataBuffer otherData = other.array.data();
        DataBuffer.Type thisType = thisData.dataType();
        if (thisType != (otherType = otherData.dataType())) {
            throw new IllegalArgumentException("Data types must be the same.");
        }
        switch (thisType) {
            case DOUBLE: {
                return thisData.asNioDouble().equals(otherData.asNioDouble());
            }
            case FLOAT: {
                return thisData.asNioFloat().equals(otherData.asNioFloat());
            }
            case INT: {
                return thisData.asNioInt().equals(otherData.asNioInt());
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + thisType);
    }

    public int hashCode() {
        DataBuffer data = this.array.data();
        DataBuffer.Type type = data.dataType();
        switch (type) {
            case DOUBLE: {
                return data.asNioDouble().hashCode();
            }
            case FLOAT: {
                return data.asNioFloat().hashCode();
            }
            case INT: {
                return data.asNioInt().hashCode();
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public int compareTo(Object o) {
        DataBuffer.Type otherType;
        NDArrayWritable other = (NDArrayWritable)((Object)o);
        DataBuffer thisData = this.array.data();
        DataBuffer otherData = other.array.data();
        DataBuffer.Type thisType = thisData.dataType();
        if (thisType != (otherType = otherData.dataType())) {
            throw new IllegalArgumentException("Data types must be the same.");
        }
        switch (thisType) {
            case DOUBLE: {
                return thisData.asNioDouble().compareTo(otherData.asNioDouble());
            }
            case FLOAT: {
                return thisData.asNioFloat().compareTo(otherData.asNioFloat());
            }
            case INT: {
                return thisData.asNioInt().compareTo(otherData.asNioInt());
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + thisType);
    }

    public String toString() {
        return this.array.toString();
    }

    public long length() {
        return this.array.data().length();
    }

    public double getDouble(long i) {
        return this.array.data().getDouble(i);
    }

    public float getFloat(long i) {
        return this.array.data().getFloat(i);
    }

    public int getInt(long i) {
        return this.array.data().getInt(i);
    }

    public long getLong(long i) {
        return (long)this.array.data().getDouble(i);
    }

    static {
        WritableComparator.define(NDArrayWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(NDArrayWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int type2;
            ByteBuffer buffer1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer buffer2 = ByteBuffer.wrap(b2, s2, l2);
            long length1 = buffer1.getLong();
            long length2 = buffer2.getLong();
            if (length1 == 0L && length2 == 0L) {
                return 0;
            }
            if (length1 == 0L) {
                return (int)Math.max(-length2, Integer.MIN_VALUE);
            }
            if (length2 == 0L) {
                return (int)Math.min(length1, Integer.MAX_VALUE);
            }
            int type1 = buffer1.getInt();
            if (type1 != (type2 = buffer2.getInt())) {
                throw new IllegalArgumentException("Data types must be the same.");
            }
            if (type1 == DataBuffer.Type.DOUBLE.ordinal()) {
                return buffer1.asDoubleBuffer().compareTo(buffer2.asDoubleBuffer());
            }
            if (type1 == DataBuffer.Type.FLOAT.ordinal()) {
                return buffer1.asFloatBuffer().compareTo(buffer2.asFloatBuffer());
            }
            if (type1 == DataBuffer.Type.INT.ordinal()) {
                return buffer1.asIntBuffer().compareTo(buffer2.asIntBuffer());
            }
            throw new UnsupportedOperationException("Unsupported data type: " + type1);
        }
    }
}

