/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.canova.api.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseImageLoader {
    protected static final Logger log = LoggerFactory.getLogger(BaseImageLoader.class);
    public static final File BASE_DIR = new File(System.getProperty("user.home"));
    public static final String[] ALLOWED_FORMATS = new String[]{"tif", "jpg", "png", "jpeg", "bmp", "JPEG", "JPG", "TIF", "PNG"};
    protected Random rng = new Random(System.currentTimeMillis());

    public void downloadAndUntar(Map urlMap, File fullDir) {
        try {
            String fileName;
            File file = new File(fullDir, urlMap.get("filesFilename").toString());
            if (!file.isFile()) {
                FileUtils.copyURLToFile((URL)new URL(urlMap.get("filesURL").toString()), (File)file);
            }
            if ((fileName = file.toString()).endsWith(".tgz") || fileName.endsWith(".tar.gz") || fileName.endsWith(".gz") || fileName.endsWith(".zip")) {
                ArchiveUtils.unzipFileTo((String)file.getAbsolutePath(), (String)fullDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to fetch images", e);
        }
    }
}

