/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.canova.api.records.reader.RecordReader;
import org.canova.image.loader.BaseImageLoader;

public class CifarLoader
extends BaseImageLoader {
    public static final int NUM_TRAIN_IMAGES = 50000;
    public static final int NUM_TEST_IMAGES = 10000;
    public static final int NUM_LABELS = 10;
    public static final int WIDTH = 32;
    public static final int HEIGHT = 32;
    public static final int CHANNELS = 3;
    public String dataBinUrl = "https://www.cs.toronto.edu/~kriz/cifar-10-binary.tar.gz";
    public String dataBinFile = "cifar-10-binary";
    protected String labelFileName = "batches.meta.txt ";
    protected List<String> labels = new ArrayList<String>();
    protected Map<String, String> labelIdMap = new LinkedHashMap<String, String>();
    String[] fileNames = new String[]{"data_batch_1.bin", "data_batch_2.bin", "data_batch_3.bin", "data_batch_4.bin", "data_batch5.bin", "test_batch.bin"};
    public String localDir = "cifar";
    protected File fullDir = new File(BASE_DIR, this.localDir);
    protected String regexPattern;
    protected int numExamples = 50000;
    protected int numLabels = 10;
    public static Map<String, String> cifarTrainData = new HashMap<String, String>();

    public CifarLoader(String localDir) {
        this.localDir = localDir;
        this.fullDir = new File(localDir);
        this.load();
    }

    public CifarLoader() {
        this.load();
    }

    public void generateMaps() {
        cifarTrainData.put("filesFilename", new File(this.dataBinUrl).getName());
        cifarTrainData.put("filesURL", this.dataBinUrl);
        cifarTrainData.put("filesFilenameUnzipped", this.dataBinFile);
    }

    private void defineLabels() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.labelFileName));
            while ((line = br.readLine()) != null) {
                String[] row = line.split(",");
                this.labelIdMap.put(row[0], row[1]);
                this.labels.add(row[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        this.generateMaps();
        this.defineLabels();
        if (!this.fullDir.exists()) {
            this.fullDir.mkdir();
            log.info("Downloading {}...", (Object)this.localDir);
            this.downloadAndUntar(cifarTrainData, this.fullDir);
        }
    }

    public boolean imageFilesExist() {
        File f = new File(BASE_DIR, cifarTrainData.get("filesFilenameUnzipped"));
        return f.exists();
    }

    public RecordReader getRecordReader() {
        return this.getRecordReader(32, 32, 3, false, this.regexPattern);
    }

    public RecordReader getRecordReader(int width, int height, int channels) {
        return this.getRecordReader(width, height, channels, false, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples) {
        this.numExamples = numExamples;
        return this.getRecordReader(32, 32, 3, false, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples, int numCategories) {
        this.numExamples = numExamples;
        this.numLabels = numCategories;
        return this.getRecordReader(32, 32, 3, false, this.regexPattern);
    }

    public RecordReader getRecordReader(int width, int height, int channels, int numExamples) {
        this.numExamples = numExamples;
        return this.getRecordReader(width, height, channels, false, this.regexPattern);
    }

    public RecordReader getRecordReader(int width, int height, int channels, boolean appendLabel, String regexPattern) {
        throw new NotImplementedException("Cifar loader is still development. Pull content directly from https://www.cs.toronto.edu/~kriz/cifar-10-python.tar.gz for now.");
    }
}

