/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.loader;

import com.github.jaiimageio.impl.plugins.tiff.TIFFImageReaderSpi;
import com.github.jaiimageio.impl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import org.canova.image.loader.ImageByteBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class ImageLoader
implements Serializable {
    private int width = -1;
    private int height = -1;
    private int channels = -1;

    public ImageLoader() {
    }

    public ImageLoader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ImageLoader(int width, int height, int channels) {
        this.width = width;
        this.height = height;
        this.channels = channels;
    }

    public INDArray asRowVector(File f) throws Exception {
        if (this.channels == 3) {
            return this.toRaveledTensor(f);
        }
        return ArrayUtil.toNDArray((int[])this.flattenedImageFromFile(f));
    }

    public INDArray asRowVector(InputStream inputStream) {
        return this.asMatrix(inputStream).ravel();
    }

    public INDArray asRowVector(BufferedImage image) {
        image = this.scalingIfNeed(image, true);
        if (this.channels == 3) {
            return this.toINDArrayBGR(image).ravel();
        }
        int[][] ret = this.toIntArrayArray(image);
        return ArrayUtil.toNDArray((int[])ArrayUtil.flatten((int[][])ret));
    }

    public INDArray toRaveledTensor(File file) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            INDArray ret = this.toRaveledTensor(bis);
            bis.close();
            return ret.ravel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public INDArray toRaveledTensor(InputStream is) {
        return this.toBgr(is).ravel();
    }

    public INDArray toRaveledTensor(BufferedImage image) {
        try {
            image = this.scalingIfNeed(image, false);
            return this.toINDArrayBGR(image).ravel();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load image", e);
        }
    }

    public INDArray toBgr(File file) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            INDArray ret = this.toBgr(bis);
            bis.close();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public INDArray toBgr(InputStream inputStream) {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            return this.toBgr(image);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load image", e);
        }
    }

    public INDArray toBgr(BufferedImage image) {
        if (image == null) {
            throw new IllegalStateException("Unable to load image");
        }
        image = this.scalingIfNeed(image, false);
        return this.toINDArrayBGR(image);
    }

    public INDArray asMatrix(File f) throws IOException {
        return ArrayUtil.toNDArray((int[][])this.fromFile(f));
    }

    public INDArray asMatrix(InputStream inputStream) {
        if (this.channels == 3) {
            return this.toBgr(inputStream);
        }
        try {
            BufferedImage image = ImageIO.read(inputStream);
            return this.asMatrix(image);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load image", e);
        }
    }

    public INDArray asMatrix(BufferedImage image) {
        if (this.channels == 3) {
            return this.toBgr(image);
        }
        image = this.scalingIfNeed(image, true);
        int w = image.getWidth();
        int h = image.getHeight();
        INDArray ret = Nd4j.create((int)h, (int)w);
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                ret.putScalar(new int[]{i, j}, image.getRGB(i, j));
            }
        }
        return ret;
    }

    public INDArray asImageMiniBatches(File f, int numMiniBatches, int numRowsPerSlice) {
        try {
            INDArray d = this.asMatrix(f);
            return Nd4j.create((int[])new int[]{numMiniBatches, numRowsPerSlice, d.columns()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[] flattenedImageFromFile(File f) throws Exception {
        return ArrayUtil.flatten((int[][])this.fromFile(f));
    }

    public int[][] fromFile(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        image = this.scalingIfNeed(image, true);
        return this.toIntArrayArray(image);
    }

    public int[][][] fromFileMultipleChannels(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        image = this.scalingIfNeed(image, this.channels > 3);
        int w = image.getWidth();
        int h = image.getHeight();
        int bands = image.getSampleModel().getNumBands();
        int[][][] ret = new int[this.channels][h][w];
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                for (int k = 0; k < this.channels && k < bands; ++k) {
                    ret[k][i][j] = pixels[this.channels * w * i + this.channels * j + k];
                }
            }
        }
        return ret;
    }

    public static BufferedImage toImage(INDArray matrix) {
        BufferedImage img = new BufferedImage(matrix.rows(), matrix.columns(), 2);
        WritableRaster r = img.getRaster();
        int[] equiv = new int[matrix.length()];
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = (int)matrix.getDouble(i);
        }
        r.setDataElements(0, 0, matrix.rows(), matrix.columns(), equiv);
        return img;
    }

    private static int[] rasterData(INDArray matrix) {
        int[] ret = new int[matrix.length()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)Math.round((Double)matrix.getScalar(i).element());
        }
        return ret;
    }

    public void toBufferedImageRGB(INDArray arr, BufferedImage image) {
        if (arr.rank() < 3) {
            throw new IllegalArgumentException("Arr must be 3d");
        }
        image = this.scalingIfNeed(image, arr.size(-2), arr.size(-1), true);
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int r = arr.slice(0).getInt(new int[]{i, j});
                int g = arr.slice(1).getInt(new int[]{i, j});
                int b = arr.slice(2).getInt(new int[]{i, j});
                int a = 1;
                int col = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(i, j, col);
            }
        }
    }

    public static BufferedImage toBufferedImage(Image img, int type) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), type);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    protected int[][] toIntArrayArray(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[][] ret = new int[h][w];
        if (image.getRaster().getNumDataElements() == 1) {
            WritableRaster raster = image.getRaster();
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    ret[i][j] = raster.getSample(j, i, 0);
                }
            }
        } else {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    ret[i][j] = image.getRGB(j, i);
                }
            }
        }
        return ret;
    }

    protected INDArray toINDArrayBGR(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int bands = image.getSampleModel().getNumBands();
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[] shape = new int[]{height, width, bands};
        INDArray ret = Nd4j.create((DataBuffer)new ImageByteBuffer(pixels, pixels.length), (int[])shape);
        return ret.permute(new int[]{2, 0, 1});
    }

    public BufferedImage centerCropIfNeeded(BufferedImage img) {
        int x = 0;
        int y = 0;
        int width = img.getWidth();
        int height = img.getHeight();
        int diff = Math.abs(width - height) / 2;
        if (width > height) {
            x = diff;
            width -= diff;
        } else if (height > width) {
            y = diff;
            height -= diff;
        }
        return img.getSubimage(x, y, width, height);
    }

    protected BufferedImage scalingIfNeed(BufferedImage image, boolean needAlpha) {
        return this.scalingIfNeed(image, this.width, this.height, needAlpha);
    }

    protected BufferedImage scalingIfNeed(BufferedImage image, int dstWidth, int dstHeight, boolean needAlpha) {
        if (dstHeight > 0 && dstWidth > 0 && (image.getHeight() != dstHeight || image.getWidth() != dstWidth)) {
            Image scaled = image.getScaledInstance(dstWidth, dstHeight, 4);
            if (needAlpha && image.getColorModel().hasAlpha() && this.channels == 6) {
                return ImageLoader.toBufferedImage(scaled, 6);
            }
            if (this.channels == 10) {
                return ImageLoader.toBufferedImage(scaled, 10);
            }
            return ImageLoader.toBufferedImage(scaled, 5);
        }
        if (image.getType() == 6 || image.getType() == 5) {
            return image;
        }
        if (needAlpha && image.getColorModel().hasAlpha() && this.channels == 6) {
            return ImageLoader.toBufferedImage(image, 6);
        }
        if (this.channels == 10) {
            return ImageLoader.toBufferedImage(image, 10);
        }
        return ImageLoader.toBufferedImage(image, 5);
    }

    static {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        registry.registerServiceProvider(new TIFFImageWriterSpi());
        registry.registerServiceProvider(new TIFFImageReaderSpi());
    }
}

