/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.recordreader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.DoubleWritable;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.SequenceRecordReader;
import org.canova.api.split.FileSplit;
import org.canova.api.split.InputSplit;
import org.canova.api.split.InputStreamInputSplit;
import org.canova.api.writable.Writable;
import org.canova.common.RecordConverter;
import org.canova.image.loader.ImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class VideoRecordReader
implements SequenceRecordReader {
    private Iterator<File> iter;
    private ImageLoader imageLoader;
    private List<String> labels = new ArrayList<String>();
    private boolean appendLabel = false;
    private Collection<Writable> record;
    private boolean hitImage = false;
    private final List<String> allowedFormats = Arrays.asList("tif", "jpg", "png", "jpeg");
    private Configuration conf;
    public static final String WIDTH = NAME_SPACE + ".video.width";
    public static final String HEIGHT = NAME_SPACE + ".video.height";
    protected InputSplit inputSplit;

    public VideoRecordReader() {
    }

    public VideoRecordReader(int width, int height, List<String> labels) {
        this(width, height, false);
        this.labels = labels;
    }

    public VideoRecordReader(int width, int height, boolean appendLabel, List<String> labels) {
        this.appendLabel = appendLabel;
        this.imageLoader = new ImageLoader(width, height);
        this.labels = labels;
    }

    public VideoRecordReader(int width, int height) {
        this(width, height, false);
        this.imageLoader = new ImageLoader(width, height);
    }

    public VideoRecordReader(int width, int height, boolean appendLabel) {
        this.appendLabel = appendLabel;
        this.imageLoader = new ImageLoader(width, height);
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (split instanceof FileSplit) {
            URI[] locations = split.locations();
            if (locations != null && locations.length >= 1) {
                if (locations.length > 1) {
                    ArrayList<File> allFiles = new ArrayList<File>();
                    for (URI location : locations) {
                        File parentDir;
                        String name;
                        File iter = new File(location);
                        if (iter.isDirectory()) {
                            File parentDir2;
                            String name2;
                            allFiles.add(iter);
                            if (!this.appendLabel || this.labels.contains(name2 = (parentDir2 = iter.getParentFile()).getName())) continue;
                            this.labels.add(name2);
                            continue;
                        }
                        File parent = iter.getParentFile();
                        if (allFiles.contains(parent) || !this.containsFormat(iter.getAbsolutePath())) continue;
                        allFiles.add(parent);
                        if (!this.appendLabel || this.labels.contains(name = (parentDir = iter.getParentFile()).getName())) continue;
                        this.labels.add(name);
                    }
                    this.iter = allFiles.iterator();
                } else {
                    File curr = new File(locations[0]);
                    if (!curr.exists()) {
                        throw new IllegalArgumentException("Path " + curr.getAbsolutePath() + " does not exist!");
                    }
                    this.iter = curr.isDirectory() ? FileUtils.iterateFiles((File)curr, null, (boolean)true) : Collections.singletonList(curr).iterator();
                }
            }
        } else if (split instanceof InputStreamInputSplit) {
            InputStreamInputSplit split2 = (InputStreamInputSplit)split;
            InputStream is = split2.getIs();
            URI[] locations = split2.locations();
            INDArray load = this.imageLoader.asMatrix(is);
            this.record = RecordConverter.toRecord((INDArray)load);
            if (this.appendLabel) {
                Path path = Paths.get(locations[0]);
                String parent = path.getParent().toString();
                this.record.add((Writable)new DoubleWritable((double)this.labels.indexOf(parent)));
            }
            is.close();
        }
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.conf = conf;
        this.appendLabel = conf.getBoolean(APPEND_LABEL, false);
        this.imageLoader = new ImageLoader(conf.getInt(WIDTH, 28), conf.getInt(HEIGHT, 28));
        this.initialize(split);
    }

    private boolean containsFormat(String format) {
        for (String format2 : this.allowedFormats) {
            if (!format.endsWith("." + format2)) continue;
            return true;
        }
        return false;
    }

    public Collection<Writable> next() {
        if (this.iter != null) {
            ArrayList<Writable> ret = new ArrayList<Writable>();
            File image = this.iter.next();
            if (image.isDirectory() || !this.containsFormat(image.getAbsolutePath())) {
                return this.next();
            }
            try {
                INDArray row = this.imageLoader.asRowVector(image);
                for (int i = 0; i < row.length(); ++i) {
                    ret.add((Writable)new DoubleWritable(row.getDouble(i)));
                }
                if (this.appendLabel) {
                    ret.add((Writable)new DoubleWritable((double)this.labels.indexOf(image.getParentFile().getName())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.iter.hasNext()) {
                return ret;
            }
            if (this.iter.hasNext()) {
                try {
                    ret.add((Writable)new Text(FileUtils.readFileToString((File)this.iter.next())));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        if (this.record != null) {
            this.hitImage = true;
            return this.record;
        }
        throw new IllegalStateException("No more elements");
    }

    public boolean hasNext() {
        if (this.iter != null) {
            return this.iter.hasNext();
        }
        if (this.record != null) {
            return !this.hitImage;
        }
        throw new IllegalStateException("Indeterminant state: record must not be null, or a file iterator must exist");
    }

    public void close() throws IOException {
    }

    public Collection<Collection<Writable>> sequenceRecord() {
        File next = this.iter.next();
        if (!next.isDirectory()) {
            return Collections.emptyList();
        }
        File[] list = next.listFiles();
        ArrayList<Collection<Writable>> ret = new ArrayList<Collection<Writable>>();
        for (File f : list) {
            try {
                Collection record = RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(f));
                ret.add(record);
                if (!this.appendLabel) continue;
                record.add(new DoubleWritable((double)this.labels.indexOf(next.getName())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public List<String> getLabels() {
        return null;
    }

    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.initialize(this.inputSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during LineRecordReader reset", e);
        }
    }
}

