/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.split.LimitFileSplit;
import org.canova.image.loader.BaseImageLoader;
import org.canova.image.recordreader.ImageRecordReader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LFWLoader
extends BaseImageLoader
implements Serializable {
    public static final int NUM_IMAGES = 13233;
    public static final int NUM_LABELS = 5749;
    public static final int SUB_NUM_IMAGES = 1054;
    public static final int SUB_NUM_LABELS = 432;
    public static final int CHANNELS = 3;
    public static final int HEIGHT = 250;
    public static final int WIDTH = 250;
    public static final String DATA_URL = "http://vis-www.cs.umass.edu/lfw/lfw.tgz";
    public static final String LABEL_URL = "http://vis-www.cs.umass.edu/lfw/lfw-names.txt";
    public static final String SUBSET_URL = "http://vis-www.cs.umass.edu/lfw/lfw-a.tgz";
    public String dataFile = "lfw";
    public String labelFile = "lfw-names.txt";
    public String subsetFile = "lfw-a";
    public String localDir = "lfw";
    public String localSubDir = "lfw-a/lfw";
    protected File fullDir = new File(BASE_DIR, this.localDir);
    protected String regexPattern = ".[0-9]+";
    protected boolean useSubset = false;
    protected int numExamples = 13233;
    protected int numLabels = 5749;
    public static Map<String, String> lfwData = new HashMap<String, String>();
    public static Map<String, String> lfwLabel = new HashMap<String, String>();
    public static Map<String, String> lfwSubsetData = new HashMap<String, String>();

    public LFWLoader(String localDir, boolean useSubset) {
        this.localDir = localDir;
        this.fullDir = new File(localDir);
        this.useSubset = useSubset;
        if (useSubset) {
            this.numExamples = 1054;
            this.numLabels = 432;
        }
        this.generateLfwMaps();
        if (!this.imageFilesExist()) {
            this.load();
        }
    }

    public LFWLoader(boolean useSubset) {
        this.useSubset = useSubset;
        if (useSubset) {
            this.fullDir = new File(BASE_DIR, this.localSubDir);
            this.numExamples = 1054;
            this.numLabels = 432;
        }
        this.generateLfwMaps();
        if (!this.imageFilesExist()) {
            this.load();
        }
    }

    public LFWLoader(String path) {
        this(path, false);
    }

    public LFWLoader() {
        this(false);
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asRowVector(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void generateLfwMaps() {
        if (this.useSubset) {
            lfwSubsetData.put("filesFilename", new File(SUBSET_URL).getName());
            lfwSubsetData.put("filesURL", SUBSET_URL);
            lfwSubsetData.put("filesFilenameUnzipped", this.subsetFile);
        } else {
            lfwData.put("filesFilename", new File(DATA_URL).getName());
            lfwData.put("filesURL", DATA_URL);
            lfwData.put("filesFilenameUnzipped", this.dataFile);
            lfwLabel.put("filesFilename", this.labelFile);
            lfwLabel.put("filesURL", LABEL_URL);
            lfwLabel.put("filesFilenameUnzipped", this.labelFile);
        }
    }

    public void load() {
        if (!this.fullDir.exists() || this.fullDir.listFiles() == null || this.fullDir.listFiles().length == 0) {
            this.fullDir.mkdir();
            if (this.useSubset) {
                log.info("Downloading {} subset...", (Object)this.localDir);
                this.downloadAndUntar(lfwSubsetData, this.fullDir);
            } else {
                log.info("Downloading {}...", (Object)this.localDir);
                this.downloadAndUntar(lfwData, this.fullDir);
                this.downloadAndUntar(lfwLabel, this.fullDir);
            }
        }
    }

    public boolean imageFilesExist() {
        if (this.useSubset) {
            File f = new File(BASE_DIR, lfwSubsetData.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
        } else {
            File f = new File(BASE_DIR, lfwData.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
            f = new File(BASE_DIR, lfwLabel.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
        }
        return true;
    }

    public RecordReader getRecordReader() {
        return this.getRecordReader(250, 250, 3, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int height, int width, int channels) {
        return this.getRecordReader(height, width, channels, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples) {
        this.numExamples = numExamples;
        return this.getRecordReader(250, 250, 3, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples, int numCategories) {
        this.numExamples = numExamples;
        this.numLabels = numCategories;
        return this.getRecordReader(250, 250, 3, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples, int height, int width, int channels) {
        this.numExamples = numExamples;
        return this.getRecordReader(height, width, channels, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples, int height, int width, int channels, Random rng) {
        this.numExamples = numExamples;
        this.rng = rng;
        return this.getRecordReader(height, width, channels, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int numExamples, int height, int width, int channels, int numLabels, Random rng) {
        this.numExamples = numExamples;
        this.numLabels = numLabels;
        this.rng = rng;
        return this.getRecordReader(height, width, channels, true, this.regexPattern);
    }

    public RecordReader getRecordReader(int height, int width, int channels, boolean appendLabel, String regexPattern) {
        if (!this.imageFilesExist()) {
            this.load();
        }
        ImageRecordReader recordReader = new ImageRecordReader(height, width, channels, appendLabel, regexPattern);
        try {
            recordReader.initialize((InputSplit)new LimitFileSplit(this.fullDir, ALLOWED_FORMATS, this.numExamples, this.numLabels, regexPattern, this.rng));
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return recordReader;
    }
}

