/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgcodecs;
import org.bytedeco.javacpp.opencv_imgproc;
import org.canova.image.loader.BaseImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class NativeImageLoader
extends BaseImageLoader {
    public NativeImageLoader() {
    }

    public NativeImageLoader(int height, int width) {
        this.height = height;
        this.width = width;
    }

    public NativeImageLoader(int height, int width, int channels) {
        this.height = height;
        this.width = width;
        this.channels = channels;
    }

    public NativeImageLoader(int height, int width, int channels, boolean centerCropIfNeeded) {
        this(height, width, channels);
        this.centerCropIfNeeded = centerCropIfNeeded;
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        return this.asMatrix(f).ravel();
    }

    @Override
    public INDArray asRowVector(InputStream is) throws IOException {
        return this.asMatrix(is).ravel();
    }

    public INDArray asRowVector(opencv_core.Mat image) throws IOException {
        return this.asMatrix(image).ravel();
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        opencv_core.Mat image = opencv_imgcodecs.imread((String)f.getAbsolutePath(), (int)(this.channels == 1 ? 0 : (this.channels == 3 ? 1 : -1)));
        if (image == null) {
            throw new IOException("Could not read image from file: " + f);
        }
        return this.asMatrix(image);
    }

    @Override
    public INDArray asMatrix(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        opencv_core.Mat image = opencv_imgcodecs.imdecode((opencv_core.Mat)new opencv_core.Mat(bytes), (int)(this.channels == 1 ? 0 : (this.channels == 3 ? 1 : -1)));
        if (image == null) {
            throw new IOException("Could not decode image from input stream");
        }
        return this.asMatrix(image);
    }

    public INDArray asMatrix(opencv_core.Mat image) throws IOException {
        if (this.channels > 0 && image.channels() != this.channels) {
            int code = -1;
            block0 : switch (image.channels()) {
                case 1: {
                    switch (this.channels) {
                        case 3: {
                            code = 8;
                            break;
                        }
                        case 4: {
                            code = 9;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.channels) {
                        case 1: {
                            code = 6;
                            break;
                        }
                        case 4: {
                            code = 2;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.channels) {
                        case 1: {
                            code = 11;
                            break block0;
                        }
                        case 3: {
                            code = 3;
                        }
                    }
                }
            }
            if (code < 0) {
                throw new IOException("Cannot convert from " + image.channels() + " to " + this.channels + " channels.");
            }
            opencv_core.Mat newimage = new opencv_core.Mat();
            opencv_imgproc.cvtColor((opencv_core.Mat)image, (opencv_core.Mat)newimage, (int)code);
            image = newimage;
        }
        if (this.centerCropIfNeeded) {
            image = this.centerCropIfNeeded(image);
        }
        image = this.scalingIfNeed(image);
        int rows = image.rows();
        int cols = image.cols();
        int channels = image.channels();
        UByteIndexer idx = (UByteIndexer)image.createIndexer();
        INDArray ret = channels > 1 ? Nd4j.create((int[])new int[]{channels, rows, cols}) : Nd4j.create((int)rows, (int)cols);
        for (int k = 0; k < channels; ++k) {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    if (channels > 1) {
                        ret.putScalar(k, i, j, (double)idx.get((long)i, (long)j, (long)k));
                        continue;
                    }
                    ret.putScalar(i, j, (double)idx.get((long)i, (long)j));
                }
            }
        }
        return ret;
    }

    protected opencv_core.Mat centerCropIfNeeded(opencv_core.Mat img) {
        int x = 0;
        int y = 0;
        int height = img.rows();
        int width = img.cols();
        int diff = Math.abs(width - height) / 2;
        if (width > height) {
            x = diff;
            width -= diff;
        } else if (height > width) {
            y = diff;
            height -= diff;
        }
        return img.apply(new opencv_core.Rect(x, y, width, height));
    }

    protected opencv_core.Mat scalingIfNeed(opencv_core.Mat image) {
        return this.scalingIfNeed(image, this.height, this.width);
    }

    protected opencv_core.Mat scalingIfNeed(opencv_core.Mat image, int dstHeight, int dstWidth) {
        opencv_core.Mat scaled = image;
        if (dstHeight > 0 && dstWidth > 0 && (image.rows() != dstHeight || image.cols() != dstWidth)) {
            scaled = new opencv_core.Mat();
            opencv_imgproc.resize((opencv_core.Mat)image, (opencv_core.Mat)scaled, (opencv_core.Size)new opencv_core.Size(dstWidth, dstHeight));
        }
        return scaled;
    }
}

