/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.mnist;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.canova.image.mnist.MnistImageFile;
import org.canova.image.mnist.MnistLabelFile;

public class MnistManager {
    private MnistImageFile images;
    private MnistLabelFile labels;

    public static void writeImageToPpm(int[][] image, String ppmFileName) throws IOException {
        try (BufferedWriter ppmOut = new BufferedWriter(new FileWriter(ppmFileName));){
            int rows = image.length;
            int cols = image[0].length;
            ppmOut.write("P3\n");
            ppmOut.write("" + rows + " " + cols + " 255\n");
            for (int[] anImage : image) {
                StringBuilder s = new StringBuilder();
                for (int j = 0; j < cols; ++j) {
                    s.append(anImage[j] + " " + anImage[j] + " " + anImage[j] + "  ");
                }
                ppmOut.write(s.toString());
            }
        }
    }

    public MnistManager(String imagesFile, String labelsFile) throws IOException {
        if (imagesFile != null) {
            this.images = new MnistImageFile(imagesFile, "r");
        }
        if (labelsFile != null) {
            this.labels = new MnistLabelFile(labelsFile, "r");
        }
    }

    public int[][] readImage() throws IOException {
        if (this.images == null) {
            throw new IllegalStateException("Images file not initialized.");
        }
        return this.images.readImage();
    }

    public void setCurrent(int index) {
        this.images.setCurrentIndex(index);
        this.labels.setCurrentIndex(index);
    }

    public int readLabel() throws IOException {
        if (this.labels == null) {
            throw new IllegalStateException("labels file not initialized.");
        }
        return this.labels.readLabel();
    }

    public MnistImageFile getImages() {
        return this.images;
    }

    public MnistLabelFile getLabels() {
        return this.labels;
    }
}

