/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.recordreader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.canova.api.io.data.IntWritable;
import org.canova.api.io.data.Text;
import org.canova.api.io.labels.PathLabelGenerator;
import org.canova.api.split.FileSplit;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;
import org.canova.common.RecordConverter;
import org.canova.image.loader.NativeImageLoader;
import org.canova.image.recordreader.BaseImageRecordReader;
import org.canova.image.transform.ImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ImageNetRecordReader
extends BaseImageRecordReader {
    protected static Logger log = LoggerFactory.getLogger(ImageNetRecordReader.class);
    protected Map<String, String> labelFileIdMap = new LinkedHashMap<String, String>();
    protected String labelPath;
    protected String fileNameMapPath = null;
    protected boolean eval = false;

    public ImageNetRecordReader(int[] imgDim, PathLabelGenerator labelGenerator, ImageTransform imgTransform, double normalizeValue) {
        this.height = imgDim[0];
        this.width = imgDim[1];
        this.channels = imgDim[2];
        this.eval = true;
    }

    private Map<String, String> defineLabels(String path) throws IOException {
        String line;
        LinkedHashMap<String, String> tmpMap = new LinkedHashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(path));
        while ((line = br.readLine()) != null) {
            String[] row = line.split(",");
            tmpMap.put(row[0], row[1]);
            this.labels.add(row[1]);
        }
        return tmpMap;
    }

    private void imgNetLabelSetup() throws IOException {
        if (this.labelPath != null && this.labelFileIdMap.isEmpty()) {
            this.labelFileIdMap = this.defineLabels(this.labelPath);
            this.labels = new ArrayList<String>(this.labelFileIdMap.values());
        }
        if (this.fileNameMapPath != null && this.fileNameMap.isEmpty()) {
            this.fileNameMap = this.defineLabels(this.fileNameMapPath);
        }
    }

    @Override
    public void initialize(InputSplit split) throws IOException {
        if (this.imageLoader == null) {
            this.imageLoader = new NativeImageLoader(this.height, this.width, this.channels, this.cropImage);
        }
        this.inputSplit = split;
        this.imgNetLabelSetup();
        if (split instanceof FileSplit) {
            URI[] locations = split.locations();
            if (locations != null && locations.length >= 1) {
                if (locations.length > 1) {
                    ArrayList<File> allFiles = new ArrayList<File>();
                    for (URI location : locations) {
                        File iter = new File(location);
                        if (iter.isDirectory() || !this.containsFormat(iter.getAbsolutePath())) continue;
                        allFiles.add(iter);
                    }
                    this.iter = allFiles.listIterator();
                } else {
                    File curr = new File(locations[0]);
                    if (!curr.exists()) {
                        throw new IllegalArgumentException("Path " + curr.getAbsolutePath() + " does not exist!");
                    }
                    this.iter = curr.isDirectory() ? FileUtils.iterateFiles((File)curr, null, (boolean)true) : Collections.singletonList(curr).listIterator();
                }
            }
        } else {
            throw new UnsupportedClassVersionError("Split needs to be an instance of FileSplit for this record reader.");
        }
    }

    @Override
    public Collection<Writable> next() {
        if (this.iter != null) {
            File image = (File)this.iter.next();
            if (image.isDirectory()) {
                return this.next();
            }
            try {
                this.invokeListeners(image);
                return this.load(this.imageLoader.asRowVector(image), image.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                ArrayList<Writable> ret = new ArrayList<Writable>();
                if (this.iter.hasNext()) {
                    return ret;
                }
                if (this.iter.hasNext()) {
                    try {
                        image = (File)this.iter.next();
                        this.invokeListeners(image);
                        ret.add((Writable)new Text(FileUtils.readFileToString((File)image)));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return ret;
            }
        }
        if (this.record != null) {
            this.hitImage = true;
            this.invokeListeners(this.record);
            return this.record;
        }
        throw new IllegalStateException("No more elements");
    }

    private Collection<Writable> load(INDArray image, String filename) throws IOException {
        int labelId = -1;
        Collection ret = RecordConverter.toRecord((INDArray)image);
        if (this.appendLabel && this.fileNameMapPath == null) {
            String WNID = FilenameUtils.getBaseName((String)filename).split(this.pattern)[this.patternPosition];
            labelId = this.labels.indexOf(this.labelFileIdMap.get(WNID));
        } else if (this.eval) {
            String fileName = FilenameUtils.getName((String)filename);
            labelId = this.labels.indexOf(this.labelFileIdMap.get(this.fileNameMap.get(fileName)));
        }
        if (labelId < 0) {
            throw new IllegalStateException("Illegal label " + labelId);
        }
        ret.add(new IntWritable(labelId));
        return ret;
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        this.invokeListeners(uri);
        this.imgNetLabelSetup();
        return this.load(this.imageLoader.asRowVector(dataInputStream), FilenameUtils.getName((String)uri.getPath()));
    }
}

