/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.transform;

import java.util.Random;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Frame;
import org.canova.image.data.ImageWritable;
import org.canova.image.transform.BaseImageTransform;

public class ShowImageTransform
extends BaseImageTransform {
    CanvasFrame canvas;
    int delay;

    public ShowImageTransform(CanvasFrame canvas) {
        this(canvas, -1);
    }

    public ShowImageTransform(CanvasFrame canvas, int delay) {
        super(null);
        this.canvas = canvas;
        this.delay = delay;
    }

    public ShowImageTransform(String title) {
        this(title, -1);
    }

    public ShowImageTransform(String title, int delay) {
        super(null);
        this.canvas = new CanvasFrame(title, 1.0);
        this.canvas.setDefaultCloseOperation(2);
        this.delay = delay;
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            this.canvas.dispose();
            return null;
        }
        if (!this.canvas.isVisible()) {
            return image;
        }
        Frame frame = image.getFrame();
        this.canvas.setCanvasSize(frame.imageWidth, frame.imageHeight);
        this.canvas.showImage(frame);
        if (this.delay >= 0) {
            try {
                this.canvas.waitKey(this.delay);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return image;
    }
}

