/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.ser;

import java.io.IOException;
import org.joda.time.Instant;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.ser.JodaDateSerializerBase;

public final class InstantSerializer
extends JodaDateSerializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantSerializer() {
        this(FormatConfig.DEFAULT_TIMEONLY_FORMAT);
    }

    public InstantSerializer(JacksonJodaDateFormat format) {
        super(Instant.class, format, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public InstantSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new InstantSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Instant value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

