/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.lang3.tuple.Pair;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public class AeronNDArraySerde {
    public static int byteBufferSizeFor(INDArray arr) {
        if (!arr.isCompressed()) {
            ByteBuffer buffer = arr.data().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
            ByteBuffer shapeBuffer = arr.shapeInfoDataBuffer().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
            int twoInts = 8;
            return twoInts + buffer.limit() + shapeBuffer.limit();
        }
        CompressedDataBuffer compressedDataBuffer = (CompressedDataBuffer)arr.data();
        CompressionDescriptor descriptor = compressedDataBuffer.getCompressionDescriptor();
        ByteBuffer codecByteBuffer = descriptor.toByteBuffer();
        ByteBuffer buffer = arr.data().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        ByteBuffer shapeBuffer = arr.shapeInfoDataBuffer().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        int twoInts = 8;
        return twoInts + buffer.limit() + shapeBuffer.limit() + codecByteBuffer.limit();
    }

    public static UnsafeBuffer toBuffer(INDArray arr) {
        if (arr.isView()) {
            arr = arr.dup();
        }
        if (!arr.isCompressed()) {
            ByteBuffer b3 = ByteBuffer.allocateDirect(AeronNDArraySerde.byteBufferSizeFor(arr)).order(ByteOrder.nativeOrder());
            AeronNDArraySerde.doByteBufferPutUnCompressed(arr, b3, true);
            return new UnsafeBuffer(b3);
        }
        ByteBuffer b3 = ByteBuffer.allocateDirect(AeronNDArraySerde.byteBufferSizeFor(arr)).order(ByteOrder.nativeOrder());
        AeronNDArraySerde.doByteBufferPutCompressed(arr, b3, true);
        return new UnsafeBuffer(b3);
    }

    public static void doByteBufferPutUnCompressed(INDArray arr, ByteBuffer allocated, boolean rewind) {
        ByteBuffer buffer = arr.data().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        ByteBuffer shapeBuffer = arr.shapeInfoDataBuffer().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        allocated.putInt(arr.rank());
        allocated.putInt(arr.data().dataType().ordinal());
        allocated.put(shapeBuffer);
        allocated.put(buffer);
        if (rewind) {
            allocated.rewind();
        }
    }

    public static void doByteBufferPutCompressed(INDArray arr, ByteBuffer allocated, boolean rewind) {
        CompressedDataBuffer compressedDataBuffer = (CompressedDataBuffer)arr.data();
        CompressionDescriptor descriptor = compressedDataBuffer.getCompressionDescriptor();
        ByteBuffer codecByteBuffer = descriptor.toByteBuffer();
        ByteBuffer buffer = arr.data().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        ByteBuffer shapeBuffer = arr.shapeInfoDataBuffer().pointer().asByteBuffer().order(ByteOrder.nativeOrder());
        allocated.putInt(arr.rank());
        allocated.putInt(arr.data().dataType().ordinal());
        allocated.put(shapeBuffer);
        allocated.put(codecByteBuffer);
        allocated.put(buffer);
        if (rewind) {
            allocated.rewind();
        }
    }

    public static Pair<INDArray, ByteBuffer> toArrayAndByteBuffer(DirectBuffer buffer, int offset) {
        ByteBuffer byteBuffer = buffer.byteBuffer() == null ? ByteBuffer.allocateDirect(buffer.byteArray().length).put(buffer.byteArray()).order(ByteOrder.nativeOrder()) : buffer.byteBuffer().order(ByteOrder.nativeOrder());
        byteBuffer.position(offset);
        int rank = byteBuffer.getInt();
        if (rank < 0) {
            throw new IllegalStateException("Found negative integer. Corrupt serialization?");
        }
        int shapeBufferLength = Shape.shapeInfoLength((int)rank);
        DataBuffer shapeBuff = Nd4j.createBuffer((int[])new int[shapeBufferLength]);
        DataBuffer.Type type = DataBuffer.Type.values()[byteBuffer.getInt()];
        for (int i = 0; i < shapeBufferLength; ++i) {
            shapeBuff.put((long)i, byteBuffer.getInt());
        }
        if (type != DataBuffer.Type.COMPRESSED) {
            ByteBuffer slice = byteBuffer.slice();
            DataBuffer buff = Nd4j.createBuffer((ByteBuffer)slice, (DataBuffer.Type)type, (int)Shape.length((DataBuffer)shapeBuff));
            int position = byteBuffer.position() + buff.getElementSize() * (int)buff.length();
            byteBuffer.position(position);
            INDArray arr = Nd4j.createArrayFromShapeBuffer((DataBuffer)buff.dup(), (DataBuffer)shapeBuff.dup());
            return Pair.of((Object)arr, (Object)byteBuffer);
        }
        CompressionDescriptor compressionDescriptor = CompressionDescriptor.fromByteBuffer((ByteBuffer)byteBuffer);
        ByteBuffer slice = byteBuffer.slice();
        BytePointer byteBufferPointer = new BytePointer(slice);
        CompressedDataBuffer compressedDataBuffer = new CompressedDataBuffer((Pointer)byteBufferPointer, compressionDescriptor);
        INDArray arr = Nd4j.createArrayFromShapeBuffer((DataBuffer)compressedDataBuffer.dup(), (DataBuffer)shapeBuff.dup());
        int compressLength = (int)compressionDescriptor.getCompressedLength();
        byteBuffer.position(byteBuffer.position() + compressLength);
        return Pair.of((Object)arr, (Object)byteBuffer);
    }

    public static INDArray toArray(DirectBuffer buffer, int offset) {
        return (INDArray)AeronNDArraySerde.toArrayAndByteBuffer(buffer, offset).getLeft();
    }

    public static INDArray toArray(DirectBuffer buffer) {
        return AeronNDArraySerde.toArray(buffer, 0);
    }
}

