/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.CloseHelper;
import org.agrona.concurrent.SigInt;
import org.nd4j.aeron.ipc.AeronConnectionInformation;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayFragmentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeronNDArraySubscriber
implements AutoCloseable {
    private String channel;
    private int streamId = -1;
    private int fragmentLimitCount;
    private Aeron.Context ctx;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicBoolean init = new AtomicBoolean(false);
    private static Logger log = LoggerFactory.getLogger(AeronNDArraySubscriber.class);
    private NDArrayCallback ndArrayCallback;
    private Aeron aeron;
    private Subscription subscription;
    private AtomicBoolean launched = new AtomicBoolean(false);
    private Executor executors;

    private void init() {
        this.ctx = this.ctx == null ? new Aeron.Context() : this.ctx;
        this.channel = this.channel == null ? "aeron:udp?endpoint=localhost:40123" : this.channel;
        this.fragmentLimitCount = this.fragmentLimitCount == 0 ? 1000 : this.fragmentLimitCount;
        this.streamId = this.streamId == 0 ? 10 : this.streamId;
        AtomicBoolean atomicBoolean = this.running = this.running == null ? new AtomicBoolean(true) : this.running;
        if (this.ndArrayCallback == null) {
            throw new IllegalStateException("NDArray callback must be specified in the builder.");
        }
        this.init.set(true);
        log.info("Channel subscriber " + this.channel + " and stream id " + this.streamId);
        this.launched = new AtomicBoolean(false);
    }

    public boolean launched() {
        if (this.launched == null) {
            this.launched = new AtomicBoolean(false);
        }
        return this.launched.get();
    }

    public void launch() throws Exception {
        if (this.init.get()) {
            return;
        }
        if (!this.init.get()) {
            this.init();
        }
        log.info("Subscribing to " + this.channel + " on stream Id " + this.streamId);
        log.info("Using aeron directory " + this.ctx.aeronDirectoryName());
        SigInt.register(() -> this.running.set(false));
        if (this.channel == null) {
            throw new IllegalStateException("No channel for subscriber defined");
        }
        if (this.streamId <= 0) {
            throw new IllegalStateException("No stream for subscriber defined");
        }
        if (this.aeron == null) {
            throw new IllegalStateException("No aeron instance defined");
        }
        boolean started = false;
        while (!started) {
            try {
                Subscription subscription = this.aeron.addSubscription(this.channel, this.streamId);
                Throwable throwable = null;
                try {
                    this.subscription = subscription;
                    log.info("Beginning subscribe on channel " + this.channel + " and stream " + this.streamId);
                    AeronUtil.subscriberLoop((FragmentHandler)new FragmentAssembler((FragmentHandler)new NDArrayFragmentHandler(this.ndArrayCallback)), this.fragmentLimitCount, this.running, this.launched).accept(subscription);
                    started = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (subscription == null) continue;
                    if (throwable != null) {
                        try {
                            subscription.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    subscription.close();
                }
            }
            catch (Exception e) {
                log.warn("Unable to connect...trying again on channel " + this.channel, (Throwable)e);
            }
        }
    }

    public String connectionUrl() {
        String[] split = this.channel.replace("aeron:udp?endpoint=", "").split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        return AeronConnectionInformation.of(host, port, this.streamId).toString();
    }

    public static AeronNDArraySubscriber startSubscriber(Aeron aeron, String host, int port, NDArrayCallback callback, int streamId, AtomicBoolean running) {
        AeronNDArraySubscriber subscriber = AeronNDArraySubscriber.builder().streamId(streamId).aeron(aeron).channel(AeronUtil.aeronChannel(host, port)).running(running).ndArrayCallback(callback).build();
        Thread t = new Thread(() -> {
            try {
                subscriber.launch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        return subscriber;
    }

    public static AeronNDArraySubscriber startSubscriber(Aeron.Context context, String host, int port, NDArrayCallback callback, int streamId, AtomicBoolean running) {
        AeronNDArraySubscriber subscriber = AeronNDArraySubscriber.builder().streamId(streamId).ctx(context).channel(AeronUtil.aeronChannel(host, port)).running(running).ndArrayCallback(callback).build();
        Thread t = new Thread(() -> {
            try {
                subscriber.launch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        return subscriber;
    }

    @Override
    public void close() throws Exception {
        CloseHelper.quietClose((AutoCloseable)this.subscription);
    }

    AeronNDArraySubscriber(String channel, int streamId, int fragmentLimitCount, Aeron.Context ctx, AtomicBoolean running, NDArrayCallback ndArrayCallback, Aeron aeron, Subscription subscription, AtomicBoolean launched, Executor executors) {
        this.channel = channel;
        this.streamId = streamId;
        this.fragmentLimitCount = fragmentLimitCount;
        this.ctx = ctx;
        this.running = running;
        this.ndArrayCallback = ndArrayCallback;
        this.aeron = aeron;
        this.subscription = subscription;
        this.launched = launched;
        this.executors = executors;
    }

    public static AeronNDArraySubscriberBuilder builder() {
        return new AeronNDArraySubscriberBuilder();
    }

    public String getChannel() {
        return this.channel;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getFragmentLimitCount() {
        return this.fragmentLimitCount;
    }

    public Aeron.Context getCtx() {
        return this.ctx;
    }

    public AtomicBoolean getRunning() {
        return this.running;
    }

    public AtomicBoolean getInit() {
        return this.init;
    }

    public NDArrayCallback getNdArrayCallback() {
        return this.ndArrayCallback;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public AtomicBoolean getLaunched() {
        return this.launched;
    }

    public Executor getExecutors() {
        return this.executors;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setFragmentLimitCount(int fragmentLimitCount) {
        this.fragmentLimitCount = fragmentLimitCount;
    }

    public void setCtx(Aeron.Context ctx) {
        this.ctx = ctx;
    }

    public void setRunning(AtomicBoolean running) {
        this.running = running;
    }

    public void setNdArrayCallback(NDArrayCallback ndArrayCallback) {
        this.ndArrayCallback = ndArrayCallback;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public void setLaunched(AtomicBoolean launched) {
        this.launched = launched;
    }

    public void setExecutors(Executor executors) {
        this.executors = executors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AeronNDArraySubscriber)) {
            return false;
        }
        AeronNDArraySubscriber other = (AeronNDArraySubscriber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        if (this.getFragmentLimitCount() != other.getFragmentLimitCount()) {
            return false;
        }
        Aeron.Context this$ctx = this.getCtx();
        Aeron.Context other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        AtomicBoolean this$running = this.getRunning();
        AtomicBoolean other$running = other.getRunning();
        if (this$running == null ? other$running != null : !this$running.equals(other$running)) {
            return false;
        }
        AtomicBoolean this$init = this.getInit();
        AtomicBoolean other$init = other.getInit();
        if (this$init == null ? other$init != null : !this$init.equals(other$init)) {
            return false;
        }
        NDArrayCallback this$ndArrayCallback = this.getNdArrayCallback();
        NDArrayCallback other$ndArrayCallback = other.getNdArrayCallback();
        if (this$ndArrayCallback == null ? other$ndArrayCallback != null : !this$ndArrayCallback.equals(other$ndArrayCallback)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        if (this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        AtomicBoolean this$launched = this.getLaunched();
        AtomicBoolean other$launched = other.getLaunched();
        if (this$launched == null ? other$launched != null : !this$launched.equals(other$launched)) {
            return false;
        }
        Executor this$executors = this.getExecutors();
        Executor other$executors = other.getExecutors();
        return !(this$executors == null ? other$executors != null : !this$executors.equals(other$executors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AeronNDArraySubscriber;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + this.getStreamId();
        result = result * 59 + this.getFragmentLimitCount();
        Aeron.Context $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        AtomicBoolean $running = this.getRunning();
        result = result * 59 + ($running == null ? 43 : $running.hashCode());
        AtomicBoolean $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : $init.hashCode());
        NDArrayCallback $ndArrayCallback = this.getNdArrayCallback();
        result = result * 59 + ($ndArrayCallback == null ? 43 : $ndArrayCallback.hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        AtomicBoolean $launched = this.getLaunched();
        result = result * 59 + ($launched == null ? 43 : $launched.hashCode());
        Executor $executors = this.getExecutors();
        result = result * 59 + ($executors == null ? 43 : $executors.hashCode());
        return result;
    }

    public String toString() {
        return "AeronNDArraySubscriber(channel=" + this.getChannel() + ", streamId=" + this.getStreamId() + ", fragmentLimitCount=" + this.getFragmentLimitCount() + ", ctx=" + this.getCtx() + ", running=" + this.getRunning() + ", init=" + this.getInit() + ", ndArrayCallback=" + this.getNdArrayCallback() + ", aeron=" + this.getAeron() + ", subscription=" + this.getSubscription() + ", launched=" + this.getLaunched() + ", executors=" + this.getExecutors() + ")";
    }

    public static class AeronNDArraySubscriberBuilder {
        private String channel;
        private int streamId;
        private int fragmentLimitCount;
        private Aeron.Context ctx;
        private AtomicBoolean running;
        private NDArrayCallback ndArrayCallback;
        private Aeron aeron;
        private Subscription subscription;
        private AtomicBoolean launched;
        private Executor executors;

        AeronNDArraySubscriberBuilder() {
        }

        public AeronNDArraySubscriberBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public AeronNDArraySubscriberBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public AeronNDArraySubscriberBuilder fragmentLimitCount(int fragmentLimitCount) {
            this.fragmentLimitCount = fragmentLimitCount;
            return this;
        }

        public AeronNDArraySubscriberBuilder ctx(Aeron.Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public AeronNDArraySubscriberBuilder running(AtomicBoolean running) {
            this.running = running;
            return this;
        }

        public AeronNDArraySubscriberBuilder ndArrayCallback(NDArrayCallback ndArrayCallback) {
            this.ndArrayCallback = ndArrayCallback;
            return this;
        }

        public AeronNDArraySubscriberBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public AeronNDArraySubscriberBuilder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public AeronNDArraySubscriberBuilder launched(AtomicBoolean launched) {
            this.launched = launched;
            return this;
        }

        public AeronNDArraySubscriberBuilder executors(Executor executors) {
            this.executors = executors;
            return this;
        }

        public AeronNDArraySubscriber build() {
            return new AeronNDArraySubscriber(this.channel, this.streamId, this.fragmentLimitCount, this.ctx, this.running, this.ndArrayCallback, this.aeron, this.subscription, this.launched, this.executors);
        }

        public String toString() {
            return "AeronNDArraySubscriber.AeronNDArraySubscriberBuilder(channel=" + this.channel + ", streamId=" + this.streamId + ", fragmentLimitCount=" + this.fragmentLimitCount + ", ctx=" + this.ctx + ", running=" + this.running + ", ndArrayCallback=" + this.ndArrayCallback + ", aeron=" + this.aeron + ", subscription=" + this.subscription + ", launched=" + this.launched + ", executors=" + this.executors + ")";
        }
    }
}

