/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.protocol.HeaderFlyweight;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;

public class AeronUtil {
    public static MediaDriver.Context getMediaDriverContext(int length) {
        int ipcLength = length * 16;
        ipcLength += 64;
        ipcLength *= 2;
        while (!BitUtil.isPowerOfTwo((int)ipcLength)) {
            ipcLength += 2;
        }
        MediaDriver.Context ctx = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirsDeleteOnStart(true).conductorIdleStrategy((IdleStrategy)new BusySpinIdleStrategy()).receiverIdleStrategy((IdleStrategy)new BusySpinIdleStrategy()).senderIdleStrategy((IdleStrategy)new BusySpinIdleStrategy());
        return ctx;
    }

    public static String aeronChannel(String host, int port) {
        return String.format("aeron:udp?endpoint=%s:%d", host, port);
    }

    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running, AtomicBoolean launched) {
        BusySpinIdleStrategy idleStrategy = new BusySpinIdleStrategy();
        return AeronUtil.subscriberLoop(fragmentHandler, limit, running, (IdleStrategy)idleStrategy, launched);
    }

    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running, IdleStrategy idleStrategy, AtomicBoolean launched) {
        return subscription -> {
            try {
                while (running.get()) {
                    idleStrategy.idle(subscription.poll(fragmentHandler, limit));
                    launched.set(true);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        };
    }

    public static FragmentHandler printStringMessage(int streamId) {
        return (buffer, offset, length, header) -> {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            System.out.println(String.format("Message to stream %d from session %d (%d@%d) <<%s>>", streamId, header.sessionId(), length, offset, new String(data)));
        };
    }

    public static void printError(String channel, int streamId, int sessionId, String message, HeaderFlyweight cause) {
        System.out.println(message);
    }

    public static void printRate(double messagesPerSec, double bytesPerSec, long totalMessages, long totalBytes) {
        System.out.println(String.format("%.02g msgs/sec, %.02g bytes/sec, totals %d messages %d MB", messagesPerSec, bytesPerSec, totalMessages, totalBytes / 0x100000L));
    }

    public static void printAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Available image on %s streamId=%d sessionId=%d from %s", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity()));
    }

    public static void printUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Unavailable image on %s streamId=%d sessionId=%d", subscription.channel(), subscription.streamId(), image.sessionId()));
    }
}

