/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.aeron.ipc.chunk.ChunkAccumulator;
import org.nd4j.aeron.ipc.chunk.InMemoryChunkAccumulator;
import org.nd4j.aeron.ipc.chunk.NDArrayMessageChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDArrayFragmentHandler
implements FragmentHandler {
    private static final Logger log = LoggerFactory.getLogger(NDArrayFragmentHandler.class);
    private NDArrayCallback ndArrayCallback;
    private ChunkAccumulator chunkAccumulator = new InMemoryChunkAccumulator();

    public NDArrayFragmentHandler(NDArrayCallback ndArrayCallback) {
        this.ndArrayCallback = ndArrayCallback;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int messageTypeIndex;
        ByteBuffer byteBuffer = buffer.byteBuffer();
        boolean byteArrayInput = false;
        if (byteBuffer == null) {
            byteArrayInput = true;
            byte[] destination = new byte[length];
            ByteBuffer wrap = ByteBuffer.wrap(buffer.byteArray());
            wrap.get(destination, offset, length);
            byteBuffer = ByteBuffer.wrap(destination).order(ByteOrder.nativeOrder());
        }
        if (!byteArrayInput) {
            byteBuffer.position(offset);
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        if ((messageTypeIndex = byteBuffer.getInt()) >= NDArrayMessage.MessageType.values().length) {
            throw new IllegalStateException("Illegal index on message type. Likely corrupt message. Please check the serialization of the bytebuffer. Input was bytebuffer: " + byteArrayInput);
        }
        NDArrayMessage.MessageType messageType = NDArrayMessage.MessageType.values()[messageTypeIndex];
        if (messageType == NDArrayMessage.MessageType.CHUNKED) {
            NDArrayMessageChunk chunk = NDArrayMessageChunk.fromBuffer(byteBuffer, messageType);
            if (chunk.getNumChunks() < 1) {
                throw new IllegalStateException("Found invalid number of chunks " + chunk.getNumChunks() + " on chunk index " + chunk.getChunkIndex());
            }
            this.chunkAccumulator.accumulateChunk(chunk);
            log.info("Number of chunks " + chunk.getNumChunks() + " and number of chunks " + chunk.getNumChunks() + " for id " + chunk.getId() + " is " + this.chunkAccumulator.numChunksSoFar(chunk.getId()));
            if (this.chunkAccumulator.allPresent(chunk.getId())) {
                NDArrayMessage message = this.chunkAccumulator.reassemble(chunk.getId());
                this.ndArrayCallback.onNDArrayMessage(message);
            }
        } else {
            NDArrayMessage message = NDArrayMessage.fromBuffer(buffer, offset);
            this.ndArrayCallback.onNDArrayMessage(message);
        }
    }
}

