/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc.chunk;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.aeron.ipc.chunk.ChunkAccumulator;
import org.nd4j.aeron.ipc.chunk.NDArrayMessageChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryChunkAccumulator
implements ChunkAccumulator {
    private static final Logger log = LoggerFactory.getLogger(InMemoryChunkAccumulator.class);
    private Map<String, List<NDArrayMessageChunk>> chunks = Maps.newConcurrentMap();

    @Override
    public int numChunksSoFar(String id) {
        if (!this.chunks.containsKey(id)) {
            return 0;
        }
        return this.chunks.get(id).size();
    }

    @Override
    public boolean allPresent(String id) {
        if (!this.chunks.containsKey(id)) {
            return false;
        }
        List<NDArrayMessageChunk> chunkList = this.chunks.get(id);
        return chunkList.size() == chunkList.get(0).getNumChunks();
    }

    @Override
    public NDArrayMessage reassemble(String id) {
        List<NDArrayMessageChunk> chunkList = this.chunks.get(id);
        if (chunkList.size() != chunkList.get(0).getNumChunks()) {
            throw new IllegalStateException("Unable to reassemble message chunk " + id + " missing " + (chunkList.get(0).getNumChunks() - chunkList.size()) + "chunks");
        }
        NDArrayMessageChunk[] inOrder = new NDArrayMessageChunk[chunkList.size()];
        Iterator<NDArrayMessageChunk> iterator = chunkList.iterator();
        while (iterator.hasNext()) {
            NDArrayMessageChunk chunk;
            inOrder[chunk.getChunkIndex()] = chunk = iterator.next();
        }
        NDArrayMessage message = NDArrayMessage.fromChunks(inOrder);
        chunkList.clear();
        this.chunks.remove(id);
        return message;
    }

    @Override
    public void accumulateChunk(NDArrayMessageChunk chunk) {
        String id = chunk.getId();
        if (!this.chunks.containsKey(id)) {
            ArrayList<NDArrayMessageChunk> list = new ArrayList<NDArrayMessageChunk>();
            list.add(chunk);
            this.chunks.put(id, list);
        } else {
            List<NDArrayMessageChunk> chunkList = this.chunks.get(id);
            chunkList.add(chunk);
        }
        log.debug("Accumulating chunk for id " + chunk.getId());
    }
}

