/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc.chunk;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.nd4j.aeron.ipc.NDArrayMessage;

public class NDArrayMessageChunk
implements Serializable {
    private String id;
    private int chunkSize;
    private NDArrayMessage.MessageType messageType;
    private int numChunks;
    private int chunkIndex;
    private ByteBuffer data;

    public static int sizeForMessage(NDArrayMessageChunk chunk) {
        int messageTypeSize = 4;
        int indexSize = 4;
        int numChunksSize = 4;
        int chunkSizeSize = 4;
        int idLengthSize = 4;
        return idLengthSize + messageTypeSize + indexSize + chunkSizeSize + numChunksSize + chunk.getData().limit() + chunk.getId().getBytes().length;
    }

    public static ByteBuffer toBuffer(NDArrayMessageChunk chunk) {
        ByteBuffer ret = ByteBuffer.allocateDirect(NDArrayMessageChunk.sizeForMessage(chunk)).order(ByteOrder.nativeOrder());
        ret.putInt(chunk.getMessageType().ordinal());
        ret.putInt(chunk.getNumChunks());
        ret.putInt(chunk.getChunkSize());
        ret.putInt(chunk.getId().getBytes().length);
        ret.put(chunk.getId().getBytes());
        ret.putInt(chunk.getChunkIndex());
        ret.put(chunk.getData());
        return ret;
    }

    public static NDArrayMessageChunk fromBuffer(ByteBuffer byteBuffer, NDArrayMessage.MessageType type) {
        int numChunks = byteBuffer.getInt();
        int chunkSize = byteBuffer.getInt();
        int idLength = byteBuffer.getInt();
        byte[] id = new byte[idLength];
        byteBuffer.get(id);
        String idString = new String(id);
        int index = byteBuffer.getInt();
        ByteBuffer firstData = byteBuffer.slice();
        NDArrayMessageChunk chunk = NDArrayMessageChunk.builder().chunkSize(chunkSize).numChunks(numChunks).data(firstData).messageType(type).id(idString).chunkIndex(index).build();
        return chunk;
    }

    NDArrayMessageChunk(String id, int chunkSize, NDArrayMessage.MessageType messageType, int numChunks, int chunkIndex, ByteBuffer data) {
        this.id = id;
        this.chunkSize = chunkSize;
        this.messageType = messageType;
        this.numChunks = numChunks;
        this.chunkIndex = chunkIndex;
        this.data = data;
    }

    public static NDArrayMessageChunkBuilder builder() {
        return new NDArrayMessageChunkBuilder();
    }

    public String getId() {
        return this.id;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public NDArrayMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setMessageType(NDArrayMessage.MessageType messageType) {
        this.messageType = messageType;
    }

    public void setNumChunks(int numChunks) {
        this.numChunks = numChunks;
    }

    public void setChunkIndex(int chunkIndex) {
        this.chunkIndex = chunkIndex;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayMessageChunk)) {
            return false;
        }
        NDArrayMessageChunk other = (NDArrayMessageChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getChunkSize() != other.getChunkSize()) {
            return false;
        }
        NDArrayMessage.MessageType this$messageType = this.getMessageType();
        NDArrayMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        if (this.getNumChunks() != other.getNumChunks()) {
            return false;
        }
        if (this.getChunkIndex() != other.getChunkIndex()) {
            return false;
        }
        ByteBuffer this$data = this.getData();
        ByteBuffer other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NDArrayMessageChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + this.getChunkSize();
        NDArrayMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        result = result * 59 + this.getNumChunks();
        result = result * 59 + this.getChunkIndex();
        ByteBuffer $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "NDArrayMessageChunk(id=" + this.getId() + ", chunkSize=" + this.getChunkSize() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", numChunks=" + this.getNumChunks() + ", chunkIndex=" + this.getChunkIndex() + ", data=" + this.getData() + ")";
    }

    public static class NDArrayMessageChunkBuilder {
        private String id;
        private int chunkSize;
        private NDArrayMessage.MessageType messageType;
        private int numChunks;
        private int chunkIndex;
        private ByteBuffer data;

        NDArrayMessageChunkBuilder() {
        }

        public NDArrayMessageChunkBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NDArrayMessageChunkBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public NDArrayMessageChunkBuilder messageType(NDArrayMessage.MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public NDArrayMessageChunkBuilder numChunks(int numChunks) {
            this.numChunks = numChunks;
            return this;
        }

        public NDArrayMessageChunkBuilder chunkIndex(int chunkIndex) {
            this.chunkIndex = chunkIndex;
            return this;
        }

        public NDArrayMessageChunkBuilder data(ByteBuffer data) {
            this.data = data;
            return this;
        }

        public NDArrayMessageChunk build() {
            return new NDArrayMessageChunk(this.id, this.chunkSize, this.messageType, this.numChunks, this.chunkIndex, this.data);
        }

        public String toString() {
            return "NDArrayMessageChunk.NDArrayMessageChunkBuilder(id=" + this.id + ", chunkSize=" + this.chunkSize + ", messageType=" + (Object)((Object)this.messageType) + ", numChunks=" + this.numChunks + ", chunkIndex=" + this.chunkIndex + ", data=" + this.data + ")";
        }
    }
}

