/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc.response;

import io.aeron.Aeron;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.nd4j.aeron.ipc.AeronNDArrayPublisher;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayHolder;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayResponseFragmentHandler
implements FragmentHandler {
    private NDArrayHolder holder;
    private Aeron.Context context;
    private Aeron aeron;
    private int streamId;

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (buffer != null && length > 0) {
            ByteBuffer byteBuffer = buffer.byteBuffer().order(ByteOrder.nativeOrder());
            byteBuffer.position(offset);
            byte[] b = new byte[length];
            byteBuffer.get(b);
            String hostPort = new String(b);
            System.out.println("Host port " + hostPort + " offset " + offset + " length " + length);
            String[] split = hostPort.split(":");
            if (split == null || split.length != 3) {
                System.err.println("no host port stream found");
                return;
            }
            int port = Integer.parseInt(split[1]);
            int streamToPublish = Integer.parseInt(split[2]);
            String channel = AeronUtil.aeronChannel(split[0], port);
            INDArray arrGet = this.holder.get();
            AeronNDArrayPublisher publisher = AeronNDArrayPublisher.builder().streamId(streamToPublish).aeron(this.aeron).channel(channel).build();
            try {
                publisher.publish(arrGet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                publisher.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static NDArrayResponseFragmentHandlerBuilder builder() {
        return new NDArrayResponseFragmentHandlerBuilder();
    }

    @ConstructorProperties(value={"holder", "context", "aeron", "streamId"})
    public NDArrayResponseFragmentHandler(NDArrayHolder holder, Aeron.Context context, Aeron aeron, int streamId) {
        this.holder = holder;
        this.context = context;
        this.aeron = aeron;
        this.streamId = streamId;
    }

    public static class NDArrayResponseFragmentHandlerBuilder {
        private NDArrayHolder holder;
        private Aeron.Context context;
        private Aeron aeron;
        private int streamId;

        NDArrayResponseFragmentHandlerBuilder() {
        }

        public NDArrayResponseFragmentHandlerBuilder holder(NDArrayHolder holder) {
            this.holder = holder;
            return this;
        }

        public NDArrayResponseFragmentHandlerBuilder context(Aeron.Context context) {
            this.context = context;
            return this;
        }

        public NDArrayResponseFragmentHandlerBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public NDArrayResponseFragmentHandlerBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public NDArrayResponseFragmentHandler build() {
            return new NDArrayResponseFragmentHandler(this.holder, this.context, this.aeron, this.streamId);
        }

        public String toString() {
            return "NDArrayResponseFragmentHandler.NDArrayResponseFragmentHandlerBuilder(holder=" + this.holder + ", context=" + this.context + ", aeron=" + this.aeron + ", streamId=" + this.streamId + ")";
        }
    }
}

