/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.util;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public class AeronStat {
    private static final String COUNTER_TYPE_ID = "type";
    private static final String COUNTER_IDENTITY = "identity";
    private static final String COUNTER_SESSION_ID = "session";
    private static final String COUNTER_STREAM_ID = "stream";
    private static final String COUNTER_CHANNEL = "channel";
    private static final int ONE_SECOND = 1000;
    private final CountersReader counters;
    private final Pattern typeFilter;
    private final Pattern identityFilter;
    private final Pattern sessionFilter;
    private final Pattern streamFilter;
    private final Pattern channelFilter;

    public AeronStat(CountersReader counters, Pattern typeFilter, Pattern identityFilter, Pattern sessionFilter, Pattern streamFilter, Pattern channelFilter) {
        this.counters = counters;
        this.typeFilter = typeFilter;
        this.identityFilter = identityFilter;
        this.sessionFilter = sessionFilter;
        this.streamFilter = streamFilter;
        this.channelFilter = channelFilter;
    }

    public AeronStat(CountersReader counters) {
        this.counters = counters;
        this.typeFilter = null;
        this.identityFilter = null;
        this.sessionFilter = null;
        this.streamFilter = null;
        this.channelFilter = null;
    }

    public static CountersReader mapCounters() {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc");
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        if (5 != cncVersion) {
            throw new IllegalStateException("CnC version not supported: file version=" + cncVersion);
        }
        return new CountersReader((AtomicBuffer)CncFileDescriptor.createCountersMetaDataBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaData), (AtomicBuffer)CncFileDescriptor.createCountersValuesBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaData));
    }

    public static void main(String[] args) throws Exception {
        Pattern typeFilter = null;
        Pattern identityFilter = null;
        Pattern sessionFilter = null;
        Pattern streamFilter = null;
        Pattern channelFilter = null;
        if (0 != args.length) {
            AeronStat.checkForHelp(args);
            block14: for (String arg : args) {
                int equalsIndex = arg.indexOf(61);
                if (-1 == equalsIndex) {
                    System.out.println("Arguments must be in name=pattern format: Invalid '" + arg + "'");
                    return;
                }
                String argName = arg.substring(0, equalsIndex);
                String argValue = arg.substring(equalsIndex + 1);
                switch (argName) {
                    case "type": {
                        typeFilter = Pattern.compile(argValue);
                        continue block14;
                    }
                    case "identity": {
                        identityFilter = Pattern.compile(argValue);
                        continue block14;
                    }
                    case "session": {
                        sessionFilter = Pattern.compile(argValue);
                        continue block14;
                    }
                    case "stream": {
                        streamFilter = Pattern.compile(argValue);
                        continue block14;
                    }
                    case "channel": {
                        channelFilter = Pattern.compile(argValue);
                        continue block14;
                    }
                    default: {
                        System.out.println("Unrecognised argument: '" + arg + "'");
                        return;
                    }
                }
            }
        }
        AeronStat aeronStat = new AeronStat(AeronStat.mapCounters(), typeFilter, identityFilter, sessionFilter, streamFilter, channelFilter);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            System.out.print("\u001b[H\u001b[2J");
            System.out.format("%1$tH:%1$tM:%1$tS - Aeron Stat%n", new Date());
            System.out.println("=========================");
            aeronStat.print(System.out);
            System.out.println("--");
            Thread.sleep(1000L);
        }
    }

    public void print(PrintStream out) {
        this.counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (this.filter(typeId, keyBuffer)) {
                long value = this.counters.getCounterValue(counterId);
                out.format("%3d: %,20d - %s%n", counterId, value, label);
            }
        });
    }

    private static void checkForHelp(String[] args) {
        for (String arg : args) {
            if (!"-?".equals(arg) && !"-h".equals(arg) && !"-help".equals(arg)) continue;
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file>] AeronStat%n\tfilter by optional regex patterns:%n\t[type=<pattern>]%n\t[identity=<pattern>]%n\t[sessionId=<pattern>]%n\t[streamId=<pattern>]%n\t[channel=<pattern>]%n", new Object[0]);
            System.exit(0);
        }
    }

    private boolean filter(int typeId, DirectBuffer keyBuffer) {
        if (!AeronStat.match(this.typeFilter, () -> Integer.toString(typeId))) {
            return false;
        }
        if (0 == typeId && !AeronStat.match(this.identityFilter, () -> Integer.toString(keyBuffer.getInt(0)))) {
            return false;
        }
        return !(typeId >= 1 && typeId <= 5 ? !AeronStat.match(this.identityFilter, () -> Long.toString(keyBuffer.getLong(0))) || !AeronStat.match(this.sessionFilter, () -> Integer.toString(keyBuffer.getInt(8))) || !AeronStat.match(this.streamFilter, () -> Integer.toString(keyBuffer.getInt(12))) || !AeronStat.match(this.channelFilter, () -> keyBuffer.getStringUtf8(16)) : typeId >= 6 && typeId <= 7 && !AeronStat.match(this.channelFilter, () -> keyBuffer.getStringUtf8(0)));
    }

    private static boolean match(Pattern pattern, Supplier<String> supplier) {
        return null == pattern || pattern.matcher(supplier.get()).find();
    }
}

