/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.exceptions.DriverTimeoutException;
import java.nio.ByteBuffer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.aeron.ipc.chunk.NDArrayMessageChunk;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeronNDArrayPublisher
implements AutoCloseable {
    private int streamId;
    private String channel;
    private boolean init = false;
    private Aeron.Context ctx;
    private Aeron aeron;
    private Publication publication;
    private static Logger log = LoggerFactory.getLogger(AeronNDArrayPublisher.class);
    public static final int NUM_RETRIES = 100;
    private boolean compress = true;
    private static final BusySpinIdleStrategy busySpinIdleStrategy = new BusySpinIdleStrategy();
    private int publishRetryTimeOut = 3000;

    private void init() {
        this.channel = this.channel == null ? "aeron:udp?endpoint=localhost:40123" : this.channel;
        this.streamId = this.streamId == 0 ? 10 : this.streamId;
        this.publishRetryTimeOut = this.publishRetryTimeOut == 0 ? 3000 : this.publishRetryTimeOut;
        this.ctx = this.ctx == null ? (this.ctx = new Aeron.Context()) : this.ctx;
        this.init = true;
        log.info("Channel publisher" + this.channel + " and stream " + this.streamId);
    }

    public void publish(NDArrayMessage message) throws Exception {
        if (!this.init) {
            this.init();
        }
        boolean connected = false;
        if (this.aeron == null) {
            try {
                while (!connected) {
                    this.aeron = Aeron.connect((Aeron.Context)this.ctx);
                    connected = true;
                }
            }
            catch (Exception e) {
                log.warn("Reconnecting on publisher...failed to connect");
            }
        }
        int connectionTries = 0;
        while (this.publication == null && connectionTries < 100) {
            try {
                this.publication = this.aeron.addPublication(this.channel, this.streamId);
                log.info("Created publication on channel " + this.channel + " and stream " + this.streamId);
            }
            catch (DriverTimeoutException e) {
                Thread.sleep(1000 * (connectionTries + 1));
                log.warn("Failed to connect due to driver time out on channel " + this.channel + " and stream " + this.streamId + "...retrying in " + connectionTries + " seconds");
                ++connectionTries;
            }
        }
        if (!connected && connectionTries >= 3 || this.publication == null) {
            throw new IllegalStateException("Publisher unable to connect to channel " + this.channel + " and stream " + this.streamId);
        }
        log.info("Publishing to " + this.channel + " on stream Id " + this.streamId);
        INDArray arr = message.getArr();
        if (this.isCompress()) {
            while (!message.getArr().isCompressed()) {
                Nd4j.getCompressor().compressi(arr, "GZIP");
            }
        }
        if (NDArrayMessage.byteBufferSizeForMessage(message) >= this.publication.maxMessageLength()) {
            NDArrayMessageChunk[] chunks = NDArrayMessage.chunks(message, this.publication.maxMessageLength() / 128);
            for (int i = 0; i < chunks.length; ++i) {
                ByteBuffer sendBuff = NDArrayMessageChunk.toBuffer(chunks[i]);
                sendBuff.rewind();
                UnsafeBuffer buffer = new UnsafeBuffer(sendBuff);
                this.sendBuffer((DirectBuffer)buffer);
            }
        } else {
            DirectBuffer buffer = NDArrayMessage.toBuffer(message);
            this.sendBuffer(buffer);
        }
    }

    private void sendBuffer(DirectBuffer buffer) throws Exception {
        long result;
        int tries;
        for (tries = 0; (result = this.publication.offer(buffer, 0, buffer.capacity())) < 0L && tries < 5; ++tries) {
            if (result == -2L) {
                log.info("Offer failed due to back pressure");
            } else if (result == -1L) {
                log.info("Offer failed because publisher is not connected to subscriber " + this.channel + " and stream " + this.streamId);
            } else if (result == -3L) {
                log.info("Offer failed because of an administration action in the system and channel" + this.channel + " and stream " + this.streamId);
            } else if (result == -4L) {
                log.info("Offer failed publication is closed and channel" + this.channel + " and stream " + this.streamId);
            } else {
                log.info(" Offer failed due to unknown reason and channel" + this.channel + " and stream " + this.streamId);
            }
            Thread.sleep(this.publishRetryTimeOut);
        }
        if (tries >= 5 && result == 0L) {
            throw new IllegalStateException("Failed to send message");
        }
    }

    public void publish(INDArray arr) throws Exception {
        this.publish(NDArrayMessage.wholeArrayUpdate(arr));
    }

    @Override
    public void close() throws Exception {
        if (this.publication != null) {
            CloseHelper.quietClose((AutoCloseable)this.publication);
        }
    }

    AeronNDArrayPublisher(int streamId, String channel, boolean init, Aeron.Context ctx, Aeron aeron, Publication publication, boolean compress, int publishRetryTimeOut) {
        this.streamId = streamId;
        this.channel = channel;
        this.init = init;
        this.ctx = ctx;
        this.aeron = aeron;
        this.publication = publication;
        this.compress = compress;
        this.publishRetryTimeOut = publishRetryTimeOut;
    }

    public static AeronNDArrayPublisherBuilder builder() {
        return new AeronNDArrayPublisherBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean isInit() {
        return this.init;
    }

    public Aeron.Context getCtx() {
        return this.ctx;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public Publication getPublication() {
        return this.publication;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public int getPublishRetryTimeOut() {
        return this.publishRetryTimeOut;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public void setCtx(Aeron.Context ctx) {
        this.ctx = ctx;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setPublication(Publication publication) {
        this.publication = publication;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setPublishRetryTimeOut(int publishRetryTimeOut) {
        this.publishRetryTimeOut = publishRetryTimeOut;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AeronNDArrayPublisher)) {
            return false;
        }
        AeronNDArrayPublisher other = (AeronNDArrayPublisher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        if (this.isInit() != other.isInit()) {
            return false;
        }
        Aeron.Context this$ctx = this.getCtx();
        Aeron.Context other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        if (this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron)) {
            return false;
        }
        Publication this$publication = this.getPublication();
        Publication other$publication = other.getPublication();
        if (this$publication == null ? other$publication != null : !this$publication.equals(other$publication)) {
            return false;
        }
        if (this.isCompress() != other.isCompress()) {
            return false;
        }
        return this.getPublishRetryTimeOut() == other.getPublishRetryTimeOut();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AeronNDArrayPublisher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStreamId();
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + (this.isInit() ? 79 : 97);
        Aeron.Context $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        Publication $publication = this.getPublication();
        result = result * 59 + ($publication == null ? 43 : $publication.hashCode());
        result = result * 59 + (this.isCompress() ? 79 : 97);
        result = result * 59 + this.getPublishRetryTimeOut();
        return result;
    }

    public String toString() {
        return "AeronNDArrayPublisher(streamId=" + this.getStreamId() + ", channel=" + this.getChannel() + ", init=" + this.isInit() + ", ctx=" + this.getCtx() + ", aeron=" + this.getAeron() + ", publication=" + this.getPublication() + ", compress=" + this.isCompress() + ", publishRetryTimeOut=" + this.getPublishRetryTimeOut() + ")";
    }

    public static class AeronNDArrayPublisherBuilder {
        private int streamId;
        private String channel;
        private boolean init;
        private Aeron.Context ctx;
        private Aeron aeron;
        private Publication publication;
        private boolean compress;
        private int publishRetryTimeOut;

        AeronNDArrayPublisherBuilder() {
        }

        public AeronNDArrayPublisherBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public AeronNDArrayPublisherBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public AeronNDArrayPublisherBuilder init(boolean init) {
            this.init = init;
            return this;
        }

        public AeronNDArrayPublisherBuilder ctx(Aeron.Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public AeronNDArrayPublisherBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public AeronNDArrayPublisherBuilder publication(Publication publication) {
            this.publication = publication;
            return this;
        }

        public AeronNDArrayPublisherBuilder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public AeronNDArrayPublisherBuilder publishRetryTimeOut(int publishRetryTimeOut) {
            this.publishRetryTimeOut = publishRetryTimeOut;
            return this;
        }

        public AeronNDArrayPublisher build() {
            return new AeronNDArrayPublisher(this.streamId, this.channel, this.init, this.ctx, this.aeron, this.publication, this.compress, this.publishRetryTimeOut);
        }

        public String toString() {
            return "AeronNDArrayPublisher.AeronNDArrayPublisherBuilder(streamId=" + this.streamId + ", channel=" + this.channel + ", init=" + this.init + ", ctx=" + this.ctx + ", aeron=" + this.aeron + ", publication=" + this.publication + ", compress=" + this.compress + ", publishRetryTimeOut=" + this.publishRetryTimeOut + ")";
        }
    }
}

