/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.lang3.tuple.Pair;
import org.nd4j.aeron.ipc.AeronNDArraySerde;
import org.nd4j.aeron.ipc.chunk.NDArrayMessageChunk;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class NDArrayMessage
implements Serializable {
    private INDArray arr;
    private long sent;
    private long index;
    private int[] dimensions;
    private byte[] chunk;
    private int numChunks = 0;
    private static int[] WHOLE_ARRAY_UPDATE = new int[]{-1};
    private static int WHOLE_ARRAY_INDEX = -1;

    public static int numChunksForMessage(NDArrayMessage message, int chunkSize) {
        int sizeOfMessage = NDArrayMessage.byteBufferSizeForMessage(message);
        int numMessages = sizeOfMessage / chunkSize;
        if (numMessages * chunkSize < sizeOfMessage) {
            ++numMessages;
        }
        return numMessages;
    }

    public static NDArrayMessage[] chunkedMessages(NDArrayMessage arrayMessage, int chunkSize) {
        int sizeOfMessage = NDArrayMessage.byteBufferSizeForMessage(arrayMessage) - 4;
        int numMessages = sizeOfMessage / chunkSize;
        ByteBuffer direct = NDArrayMessage.toBuffer(arrayMessage).byteBuffer();
        NDArrayMessage[] ret = new NDArrayMessage[numMessages];
        for (int i = 0; i < numMessages; ++i) {
            byte[] chunk = new byte[chunkSize];
            direct.get(chunk, i * chunkSize, chunkSize);
            ret[i] = NDArrayMessage.builder().chunk(chunk).numChunks(numMessages).build();
        }
        return ret;
    }

    public static NDArrayMessage wholeArrayUpdate(INDArray arr) {
        return NDArrayMessage.builder().arr(arr).dimensions(WHOLE_ARRAY_UPDATE).index(WHOLE_ARRAY_INDEX).sent(NDArrayMessage.getCurrentTimeUtc()).build();
    }

    public static NDArrayMessage of(INDArray arr, int[] dimensions, long index) {
        if (dimensions == null) {
            dimensions = WHOLE_ARRAY_UPDATE;
        }
        if (index > 0L && (dimensions.length > 1 || dimensions.length == 1 && dimensions[0] != -1)) {
            throw new IllegalArgumentException("Inconsistent message. Your index is > 0 indicating you want to send a whole ndarray message but your dimensions indicate you are trying to send a partial update. Please ensure you use a 1 length int array with negative 1 as an element or use NDArrayMesage.wholeArrayUpdate(ndarray) for creation instead");
        }
        return NDArrayMessage.builder().index(index).dimensions(dimensions).sent(NDArrayMessage.getCurrentTimeUtc()).arr(arr).build();
    }

    public static MessageValidity validMessage(NDArrayMessage message) {
        if (message.getDimensions() == null || message.getArr() == null) {
            return MessageValidity.NULL_VALUE;
        }
        if (message.getIndex() != -1L && message.getDimensions().length == 1 && message.getDimensions()[0] != -1) {
            return MessageValidity.INCONSISTENT_DIMENSIONS;
        }
        return MessageValidity.VALID;
    }

    public static long getCurrentTimeUtc() {
        Instant instant = Instant.now();
        ZonedDateTime dateTime = instant.atZone(ZoneOffset.UTC);
        return dateTime.toInstant().toEpochMilli();
    }

    public static int byteBufferSizeForMessage(NDArrayMessage message) {
        int enumSize = 4;
        int nInts = 4 * message.getDimensions().length;
        int sizeofDimensionLength = 4;
        int timeStampSize = 8;
        int indexSize = 8;
        return enumSize + nInts + sizeofDimensionLength + timeStampSize + indexSize + AeronNDArraySerde.byteBufferSizeFor(message.getArr());
    }

    public static NDArrayMessage fromChunks(NDArrayMessageChunk[] chunks) {
        int overAllCapacity = chunks[0].getChunkSize() * chunks.length;
        ByteBuffer all = ByteBuffer.allocateDirect(overAllCapacity).order(ByteOrder.nativeOrder());
        for (int i = 0; i < chunks.length; ++i) {
            ByteBuffer curr = chunks[i].getData();
            if (curr.capacity() > chunks[0].getChunkSize()) {
                curr.position(0).limit(chunks[0].getChunkSize());
                curr = curr.slice();
            }
            all.put(curr);
        }
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(all);
        all.rewind();
        return NDArrayMessage.fromBuffer((DirectBuffer)unsafeBuffer, 0);
    }

    public static NDArrayMessageChunk[] chunks(NDArrayMessage message, int chunkSize) {
        int numChunks = NDArrayMessage.numChunksForMessage(message, chunkSize);
        NDArrayMessageChunk[] ret = new NDArrayMessageChunk[numChunks];
        DirectBuffer wholeBuffer = NDArrayMessage.toBuffer(message);
        String messageId = UUID.randomUUID().toString();
        for (int i = 0; i < ret.length; ++i) {
            NDArrayMessageChunk chunk;
            ByteBuffer view = (ByteBuffer)wholeBuffer.byteBuffer().asReadOnlyBuffer().position(i * chunkSize);
            view.limit(Math.min(i * chunkSize + chunkSize, wholeBuffer.capacity()));
            view.order(ByteOrder.nativeOrder());
            view = view.slice();
            ret[i] = chunk = NDArrayMessageChunk.builder().id(messageId).chunkSize(chunkSize).numChunks(numChunks).messageType(MessageType.CHUNKED).chunkIndex(i).data(view).build();
        }
        return ret;
    }

    public static DirectBuffer toBuffer(NDArrayMessage message) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(NDArrayMessage.byteBufferSizeForMessage(message)).order(ByteOrder.nativeOrder());
        byteBuffer.putInt(MessageType.WHOLE.ordinal());
        if (message.getArr().isCompressed()) {
            AeronNDArraySerde.doByteBufferPutCompressed(message.getArr(), byteBuffer, false);
        } else {
            AeronNDArraySerde.doByteBufferPutUnCompressed(message.getArr(), byteBuffer, false);
        }
        long sent = message.getSent();
        long index = message.getIndex();
        byteBuffer.putLong(sent);
        byteBuffer.putLong(index);
        byteBuffer.putInt(message.getDimensions().length);
        for (int i = 0; i < message.getDimensions().length; ++i) {
            byteBuffer.putInt(message.getDimensions()[i]);
        }
        byteBuffer.rewind();
        return new UnsafeBuffer(byteBuffer);
    }

    public static NDArrayMessage fromBuffer(DirectBuffer buffer, int offset) {
        Pair<INDArray, ByteBuffer> pair = AeronNDArraySerde.toArrayAndByteBuffer(buffer, offset + 4);
        INDArray arr = (INDArray)pair.getKey();
        Nd4j.getCompressor().decompressi(arr);
        ByteBuffer rest = (ByteBuffer)pair.getRight();
        long time = rest.getLong();
        long index = rest.getLong();
        int dimensionLength = rest.getInt();
        if (dimensionLength <= 0) {
            throw new IllegalArgumentException("Invalid dimension length " + dimensionLength);
        }
        int[] dimensions = new int[dimensionLength];
        for (int i = 0; i < dimensionLength; ++i) {
            dimensions[i] = rest.getInt();
        }
        return NDArrayMessage.builder().sent(time).arr(arr).index(index).dimensions(dimensions).build();
    }

    public static NDArrayMessageBuilder builder() {
        return new NDArrayMessageBuilder();
    }

    public INDArray getArr() {
        return this.arr;
    }

    public long getSent() {
        return this.sent;
    }

    public long getIndex() {
        return this.index;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public byte[] getChunk() {
        return this.chunk;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public void setArr(INDArray arr) {
        this.arr = arr;
    }

    public void setSent(long sent) {
        this.sent = sent;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
    }

    public void setChunk(byte[] chunk) {
        this.chunk = chunk;
    }

    public void setNumChunks(int numChunks) {
        this.numChunks = numChunks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayMessage)) {
            return false;
        }
        NDArrayMessage other = (NDArrayMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$arr = this.getArr();
        INDArray other$arr = other.getArr();
        if (this$arr == null ? other$arr != null : !this$arr.equals(other$arr)) {
            return false;
        }
        if (this.getSent() != other.getSent()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getDimensions(), other.getDimensions())) {
            return false;
        }
        if (!Arrays.equals(this.getChunk(), other.getChunk())) {
            return false;
        }
        return this.getNumChunks() == other.getNumChunks();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NDArrayMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $arr = this.getArr();
        result = result * 59 + ($arr == null ? 43 : $arr.hashCode());
        long $sent = this.getSent();
        result = result * 59 + (int)($sent >>> 32 ^ $sent);
        long $index = this.getIndex();
        result = result * 59 + (int)($index >>> 32 ^ $index);
        result = result * 59 + Arrays.hashCode(this.getDimensions());
        result = result * 59 + Arrays.hashCode(this.getChunk());
        result = result * 59 + this.getNumChunks();
        return result;
    }

    public String toString() {
        return "NDArrayMessage(arr=" + this.getArr() + ", sent=" + this.getSent() + ", index=" + this.getIndex() + ", dimensions=" + Arrays.toString(this.getDimensions()) + ", chunk=" + Arrays.toString(this.getChunk()) + ", numChunks=" + this.getNumChunks() + ")";
    }

    @ConstructorProperties(value={"arr", "sent", "index", "dimensions", "chunk", "numChunks"})
    public NDArrayMessage(INDArray arr, long sent, long index, int[] dimensions, byte[] chunk, int numChunks) {
        this.arr = arr;
        this.sent = sent;
        this.index = index;
        this.dimensions = dimensions;
        this.chunk = chunk;
        this.numChunks = numChunks;
    }

    public NDArrayMessage() {
    }

    public static class NDArrayMessageBuilder {
        private INDArray arr;
        private long sent;
        private long index;
        private int[] dimensions;
        private byte[] chunk;
        private int numChunks;

        NDArrayMessageBuilder() {
        }

        public NDArrayMessageBuilder arr(INDArray arr) {
            this.arr = arr;
            return this;
        }

        public NDArrayMessageBuilder sent(long sent) {
            this.sent = sent;
            return this;
        }

        public NDArrayMessageBuilder index(long index) {
            this.index = index;
            return this;
        }

        public NDArrayMessageBuilder dimensions(int[] dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public NDArrayMessageBuilder chunk(byte[] chunk) {
            this.chunk = chunk;
            return this;
        }

        public NDArrayMessageBuilder numChunks(int numChunks) {
            this.numChunks = numChunks;
            return this;
        }

        public NDArrayMessage build() {
            return new NDArrayMessage(this.arr, this.sent, this.index, this.dimensions, this.chunk, this.numChunks);
        }

        public String toString() {
            return "NDArrayMessage.NDArrayMessageBuilder(arr=" + this.arr + ", sent=" + this.sent + ", index=" + this.index + ", dimensions=" + Arrays.toString(this.dimensions) + ", chunk=" + Arrays.toString(this.chunk) + ", numChunks=" + this.numChunks + ")";
        }
    }

    public static enum MessageType {
        CHUNKED,
        WHOLE;

    }

    public static enum MessageValidity {
        VALID,
        NULL_VALUE,
        INCONSISTENT_DIMENSIONS;

    }
}

