/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc.response;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.CloseHelper;
import org.agrona.concurrent.SigInt;
import org.nd4j.aeron.ipc.AeronConnectionInformation;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayHolder;
import org.nd4j.aeron.ipc.response.NDArrayResponseFragmentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeronNDArrayResponder
implements AutoCloseable {
    private String channel;
    private int streamId = -1;
    private int responseStreamId = -1;
    private int fragmentLimitCount;
    private Aeron.Context ctx;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicBoolean init = new AtomicBoolean(false);
    private static Logger log = LoggerFactory.getLogger(AeronNDArrayResponder.class);
    private NDArrayHolder ndArrayHolder;
    private Aeron aeron;
    private AtomicBoolean launched;

    private void init() {
        this.ctx = this.ctx == null ? new Aeron.Context() : this.ctx;
        this.channel = this.channel == null ? "aeron:udp?endpoint=localhost:40123" : this.channel;
        this.fragmentLimitCount = this.fragmentLimitCount == 0 ? 5000 : this.fragmentLimitCount;
        this.streamId = this.streamId == 0 ? 10 : this.streamId;
        this.responseStreamId = this.responseStreamId == 0 ? -1 : this.responseStreamId;
        AtomicBoolean atomicBoolean = this.running = this.running == null ? new AtomicBoolean(true) : this.running;
        if (this.ndArrayHolder == null) {
            throw new IllegalStateException("NDArray callback must be specified in the builder.");
        }
        this.init.set(true);
        this.launched = new AtomicBoolean(false);
        log.info("Channel subscriber " + this.channel + " and stream id " + this.streamId);
    }

    public void launch() throws Exception {
        if (this.init.get()) {
            return;
        }
        if (!this.init.get()) {
            this.init();
        }
        log.info("Subscribing to " + this.channel + " on stream Id " + this.streamId);
        SigInt.register(() -> this.running.set(false));
        boolean started = false;
        int numTries = 0;
        while (!started && numTries < 3) {
            try {
                Subscription subscription = this.aeron.addSubscription(this.channel, this.streamId);
                Throwable throwable = null;
                try {
                    log.info("Beginning subscribe on channel " + this.channel + " and stream " + this.streamId);
                    AeronUtil.subscriberLoop((FragmentHandler)new FragmentAssembler((FragmentHandler)NDArrayResponseFragmentHandler.builder().aeron(this.aeron).context(this.ctx).streamId(this.responseStreamId).holder(this.ndArrayHolder).build()), this.fragmentLimitCount, this.running, this.launched).accept(subscription);
                    started = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (subscription == null) continue;
                    if (throwable != null) {
                        try {
                            subscription.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    subscription.close();
                }
            }
            catch (Exception e) {
                ++numTries;
                log.warn("Failed to connect..trying again", (Throwable)e);
            }
        }
        if (numTries >= 3) {
            throw new IllegalStateException("Was unable to start responder after " + numTries + "tries");
        }
    }

    public String connectionUrl() {
        String[] split = this.channel.replace("aeron:udp?endpoint=", "").split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        return AeronConnectionInformation.of(host, port, this.streamId).toString();
    }

    public static AeronNDArrayResponder startSubscriber(Aeron aeron, String host, int port, NDArrayHolder callback, int streamId) {
        if (callback == null) {
            throw new IllegalArgumentException("NDArrayHolder must be specified");
        }
        AtomicBoolean running = new AtomicBoolean(true);
        AeronNDArrayResponder subscriber = AeronNDArrayResponder.builder().streamId(streamId).aeron(aeron).channel(AeronUtil.aeronChannel(host, port)).running(running).ndArrayHolder(callback).build();
        Thread t = new Thread(() -> {
            try {
                subscriber.launch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        return subscriber;
    }

    public static AeronNDArrayResponder startSubscriber(Aeron.Context context, String host, int port, NDArrayHolder callback, int streamId) {
        if (callback == null) {
            throw new IllegalArgumentException("NDArrayHolder must be specified");
        }
        AtomicBoolean running = new AtomicBoolean(true);
        AeronNDArrayResponder subscriber = AeronNDArrayResponder.builder().streamId(streamId).ctx(context).channel(String.format("aeron:udp?endpoint=%s:%d", host, port)).running(running).ndArrayHolder(callback).build();
        Thread t = new Thread(() -> {
            try {
                subscriber.launch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        return subscriber;
    }

    @Override
    public void close() throws Exception {
        CloseHelper.close((AutoCloseable)this.aeron);
    }

    AeronNDArrayResponder(String channel, int streamId, int responseStreamId, int fragmentLimitCount, Aeron.Context ctx, AtomicBoolean running, NDArrayHolder ndArrayHolder, Aeron aeron, AtomicBoolean launched) {
        this.channel = channel;
        this.streamId = streamId;
        this.responseStreamId = responseStreamId;
        this.fragmentLimitCount = fragmentLimitCount;
        this.ctx = ctx;
        this.running = running;
        this.ndArrayHolder = ndArrayHolder;
        this.aeron = aeron;
        this.launched = launched;
    }

    public static AeronNDArrayResponderBuilder builder() {
        return new AeronNDArrayResponderBuilder();
    }

    public String getChannel() {
        return this.channel;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getResponseStreamId() {
        return this.responseStreamId;
    }

    public int getFragmentLimitCount() {
        return this.fragmentLimitCount;
    }

    public Aeron.Context getCtx() {
        return this.ctx;
    }

    public AtomicBoolean getRunning() {
        return this.running;
    }

    public AtomicBoolean getInit() {
        return this.init;
    }

    public NDArrayHolder getNdArrayHolder() {
        return this.ndArrayHolder;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public AtomicBoolean getLaunched() {
        return this.launched;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setResponseStreamId(int responseStreamId) {
        this.responseStreamId = responseStreamId;
    }

    public void setFragmentLimitCount(int fragmentLimitCount) {
        this.fragmentLimitCount = fragmentLimitCount;
    }

    public void setCtx(Aeron.Context ctx) {
        this.ctx = ctx;
    }

    public void setRunning(AtomicBoolean running) {
        this.running = running;
    }

    public void setNdArrayHolder(NDArrayHolder ndArrayHolder) {
        this.ndArrayHolder = ndArrayHolder;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setLaunched(AtomicBoolean launched) {
        this.launched = launched;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AeronNDArrayResponder)) {
            return false;
        }
        AeronNDArrayResponder other = (AeronNDArrayResponder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        if (this.getResponseStreamId() != other.getResponseStreamId()) {
            return false;
        }
        if (this.getFragmentLimitCount() != other.getFragmentLimitCount()) {
            return false;
        }
        Aeron.Context this$ctx = this.getCtx();
        Aeron.Context other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        AtomicBoolean this$running = this.getRunning();
        AtomicBoolean other$running = other.getRunning();
        if (this$running == null ? other$running != null : !this$running.equals(other$running)) {
            return false;
        }
        AtomicBoolean this$init = this.getInit();
        AtomicBoolean other$init = other.getInit();
        if (this$init == null ? other$init != null : !this$init.equals(other$init)) {
            return false;
        }
        NDArrayHolder this$ndArrayHolder = this.getNdArrayHolder();
        NDArrayHolder other$ndArrayHolder = other.getNdArrayHolder();
        if (this$ndArrayHolder == null ? other$ndArrayHolder != null : !this$ndArrayHolder.equals(other$ndArrayHolder)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        if (this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron)) {
            return false;
        }
        AtomicBoolean this$launched = this.getLaunched();
        AtomicBoolean other$launched = other.getLaunched();
        return !(this$launched == null ? other$launched != null : !this$launched.equals(other$launched));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AeronNDArrayResponder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + this.getStreamId();
        result = result * 59 + this.getResponseStreamId();
        result = result * 59 + this.getFragmentLimitCount();
        Aeron.Context $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        AtomicBoolean $running = this.getRunning();
        result = result * 59 + ($running == null ? 43 : $running.hashCode());
        AtomicBoolean $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : $init.hashCode());
        NDArrayHolder $ndArrayHolder = this.getNdArrayHolder();
        result = result * 59 + ($ndArrayHolder == null ? 43 : $ndArrayHolder.hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        AtomicBoolean $launched = this.getLaunched();
        result = result * 59 + ($launched == null ? 43 : $launched.hashCode());
        return result;
    }

    public String toString() {
        return "AeronNDArrayResponder(channel=" + this.getChannel() + ", streamId=" + this.getStreamId() + ", responseStreamId=" + this.getResponseStreamId() + ", fragmentLimitCount=" + this.getFragmentLimitCount() + ", ctx=" + this.getCtx() + ", running=" + this.getRunning() + ", init=" + this.getInit() + ", ndArrayHolder=" + this.getNdArrayHolder() + ", aeron=" + this.getAeron() + ", launched=" + this.getLaunched() + ")";
    }

    public static class AeronNDArrayResponderBuilder {
        private String channel;
        private int streamId;
        private int responseStreamId;
        private int fragmentLimitCount;
        private Aeron.Context ctx;
        private AtomicBoolean running;
        private NDArrayHolder ndArrayHolder;
        private Aeron aeron;
        private AtomicBoolean launched;

        AeronNDArrayResponderBuilder() {
        }

        public AeronNDArrayResponderBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public AeronNDArrayResponderBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public AeronNDArrayResponderBuilder responseStreamId(int responseStreamId) {
            this.responseStreamId = responseStreamId;
            return this;
        }

        public AeronNDArrayResponderBuilder fragmentLimitCount(int fragmentLimitCount) {
            this.fragmentLimitCount = fragmentLimitCount;
            return this;
        }

        public AeronNDArrayResponderBuilder ctx(Aeron.Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public AeronNDArrayResponderBuilder running(AtomicBoolean running) {
            this.running = running;
            return this;
        }

        public AeronNDArrayResponderBuilder ndArrayHolder(NDArrayHolder ndArrayHolder) {
            this.ndArrayHolder = ndArrayHolder;
            return this;
        }

        public AeronNDArrayResponderBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public AeronNDArrayResponderBuilder launched(AtomicBoolean launched) {
            this.launched = launched;
            return this;
        }

        public AeronNDArrayResponder build() {
            return new AeronNDArrayResponder(this.channel, this.streamId, this.responseStreamId, this.fragmentLimitCount, this.ctx, this.running, this.ndArrayHolder, this.aeron, this.launched);
        }

        public String toString() {
            return "AeronNDArrayResponder.AeronNDArrayResponderBuilder(channel=" + this.channel + ", streamId=" + this.streamId + ", responseStreamId=" + this.responseStreamId + ", fragmentLimitCount=" + this.fragmentLimitCount + ", ctx=" + this.ctx + ", running=" + this.running + ", ndArrayHolder=" + this.ndArrayHolder + ", aeron=" + this.aeron + ", launched=" + this.launched + ")";
        }
    }
}

