/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ipc.response;

import io.aeron.Aeron;
import io.aeron.Publication;
import java.beans.ConstructorProperties;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.nd4j.aeron.ipc.AeronNDArrayPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostPortPublisher
implements AutoCloseable {
    private String uriToSend;
    private int streamId;
    private String channel;
    private boolean init = false;
    private Aeron.Context ctx;
    private Aeron aeron;
    private Publication publication;
    private static Logger log = LoggerFactory.getLogger(AeronNDArrayPublisher.class);
    private int publicationTimeout;

    private void init() {
        this.publicationTimeout = this.publicationTimeout == 0 ? 100 : this.publicationTimeout;
        this.channel = this.channel == null ? "aeron:udp?endpoint=localhost:40123" : this.channel;
        this.streamId = this.streamId == 0 ? 10 : this.streamId;
        this.ctx = this.ctx == null ? (this.ctx = new Aeron.Context()) : this.ctx;
        this.init = true;
        log.info("Channel publisher" + this.channel + " and stream " + this.streamId);
    }

    public void send() {
        long result;
        if (!this.init) {
            this.init();
        }
        if (this.aeron == null) {
            this.aeron = Aeron.connect((Aeron.Context)this.ctx);
        }
        while (this.publication == null) {
            try {
                this.publication = this.aeron.addPublication(this.channel, this.streamId);
                log.info("Publication created on channel " + this.channel);
            }
            catch (Exception e) {
                log.warn("Trying to connect again on channel " + this.channel);
            }
        }
        UnsafeBuffer buffer = new UnsafeBuffer(this.uriToSend.getBytes());
        log.info("Begin publish " + this.channel + " and stream " + this.streamId);
        int timesFailed = 0;
        while ((result = this.publication.offer((DirectBuffer)buffer, 0, buffer.capacity())) < 0L) {
            if (result == -2L && timesFailed % 1000 == 0) {
                log.info("Offer failed due to back pressure " + this.channel + " and stream " + this.streamId);
            } else if (result == -1L && timesFailed % 1000 == 0) {
                log.info("Offer failed because publisher is not connected to subscriber " + this.channel + " and stream " + this.streamId);
            } else if (result == -3L && timesFailed % 1000 == 0) {
                log.info("Offer failed because of an administration action in the system " + this.channel + " and stream " + this.streamId);
            } else if (result == -4L && timesFailed % 1000 == 0) {
                log.info("Offer failed publication is closed " + this.channel + " and stream " + this.streamId);
            } else if (timesFailed % 1000 == 0) {
                log.info("Offer failed due to unknown reason on channel " + this.channel + " and stream " + this.streamId);
            }
            try {
                Thread.sleep(this.publicationTimeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++timesFailed;
        }
        log.info("Done sending uri " + this.uriToSend);
    }

    @Override
    public void close() throws Exception {
        if (this.publication != null) {
            CloseHelper.quietClose((AutoCloseable)this.publication);
        }
    }

    public static HostPortPublisherBuilder builder() {
        return new HostPortPublisherBuilder();
    }

    @ConstructorProperties(value={"uriToSend", "streamId", "channel", "init", "ctx", "aeron", "publication", "publicationTimeout"})
    public HostPortPublisher(String uriToSend, int streamId, String channel, boolean init, Aeron.Context ctx, Aeron aeron, Publication publication, int publicationTimeout) {
        this.uriToSend = uriToSend;
        this.streamId = streamId;
        this.channel = channel;
        this.init = init;
        this.ctx = ctx;
        this.aeron = aeron;
        this.publication = publication;
        this.publicationTimeout = publicationTimeout;
    }

    public static class HostPortPublisherBuilder {
        private String uriToSend;
        private int streamId;
        private String channel;
        private boolean init;
        private Aeron.Context ctx;
        private Aeron aeron;
        private Publication publication;
        private int publicationTimeout;

        HostPortPublisherBuilder() {
        }

        public HostPortPublisherBuilder uriToSend(String uriToSend) {
            this.uriToSend = uriToSend;
            return this;
        }

        public HostPortPublisherBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public HostPortPublisherBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public HostPortPublisherBuilder init(boolean init) {
            this.init = init;
            return this;
        }

        public HostPortPublisherBuilder ctx(Aeron.Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public HostPortPublisherBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public HostPortPublisherBuilder publication(Publication publication) {
            this.publication = publication;
            return this;
        }

        public HostPortPublisherBuilder publicationTimeout(int publicationTimeout) {
            this.publicationTimeout = publicationTimeout;
            return this;
        }

        public HostPortPublisher build() {
            return new HostPortPublisher(this.uriToSend, this.streamId, this.channel, this.init, this.ctx, this.aeron, this.publication, this.publicationTimeout);
        }

        public String toString() {
            return "HostPortPublisher.HostPortPublisherBuilder(uriToSend=" + this.uriToSend + ", streamId=" + this.streamId + ", channel=" + this.channel + ", init=" + this.init + ", ctx=" + this.ctx + ", aeron=" + this.aeron + ", publication=" + this.publication + ", publicationTimeout=" + this.publicationTimeout + ")";
        }
    }
}

