/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.aeron.ndarrayholder;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.nd4j.aeron.ipc.NDArrayHolder;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class InMemoryNDArrayHolder
implements NDArrayHolder {
    private AtomicReference<INDArray> arr = new AtomicReference();
    private AtomicInteger totalUpdates = new AtomicInteger(0);

    public InMemoryNDArrayHolder(int[] shape) {
        this.setArray(Nd4j.zeros((int[])shape));
    }

    public InMemoryNDArrayHolder(INDArray arr) {
        this.setArray(arr);
    }

    @Override
    public void setArray(INDArray arr) {
        if (this.arr.get() == null) {
            this.arr.set(arr);
        }
    }

    @Override
    public int totalUpdates() {
        return this.totalUpdates.get();
    }

    @Override
    public INDArray get() {
        return this.arr.get();
    }

    @Override
    public INDArray getTad(int idx, int ... dimensions) {
        return this.arr.get().tensorAlongDimension(idx, dimensions);
    }

    public InMemoryNDArrayHolder() {
    }
}

