/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.SigmoidDerivative;
import org.nd4j.linalg.factory.Nd4j;

public class Sigmoid
extends BaseTransformOp {
    public Sigmoid() {
    }

    public Sigmoid(INDArray x, INDArray z) {
        super(x, z);
    }

    public Sigmoid(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public Sigmoid(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Sigmoid(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public Sigmoid(INDArray ndArray) {
        super(ndArray);
    }

    @Override
    public int opNum() {
        return 10;
    }

    @Override
    public String name() {
        return "sigmoid";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.sigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.sigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.sigmoid(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)this.sigmoid(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.sigmoid(origin);
    }

    @Override
    public double op(double origin) {
        return this.sigmoid(origin);
    }

    @Override
    public float op(float origin) {
        return (float)this.sigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return this.sigmoid(origin);
    }

    private double sigmoid(double input) {
        double inputf = input;
        double val = 1.0 / (1.0 + FastMath.exp((double)(-inputf)));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY && (Double.isNaN(val) || Double.isInfinite(val))) {
            val = Nd4j.EPS_THRESHOLD;
        }
        return val;
    }

    @Override
    public TransformOp derivative() {
        return new SigmoidDerivative(this.x, this.y, this.z, this.n);
    }

    private IComplexNumber sigmoid(IComplexNumber number) {
        double arg = number.complexArgument().doubleValue();
        double sigArg = 1.0 + FastMath.exp((double)(-arg)) - 1.0 + 0.5;
        double ret = Math.exp(sigArg);
        return Nd4j.createDouble(ret, 0.0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sigmoid(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sigmoid(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sigmoid(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sigmoid(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

