/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Stabilize
extends BaseTransformOp {
    double realMin = 1.1755E-38f;
    double cutOff = FastMath.log((double)this.realMin);
    double k;

    public Stabilize() {
    }

    public Stabilize(INDArray x, INDArray z, double k) {
        super(x, z);
        this.k = k;
    }

    public Stabilize(INDArray x, INDArray z, long n, double k) {
        super(x, z, n);
        this.k = k;
    }

    public Stabilize(INDArray x, INDArray y, INDArray z, long n, double k) {
        super(x, y, z, n);
        this.k = k;
    }

    public Stabilize(INDArray x, double k) {
        super(x);
        this.k = k;
    }

    @Override
    public int opNum() {
        return 28;
    }

    @Override
    public String name() {
        return "stabilize";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.stabilize(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.stabilize(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.stabilize(origin);
    }

    @Override
    public float op(float origin, float other) {
        return this.stabilize(origin);
    }

    private float stabilize(float curr) {
        if ((double)curr * this.k > -this.cutOff) {
            return (float)(-this.cutOff / this.k);
        }
        if ((double)curr * this.k < this.cutOff) {
            return (float)(this.cutOff / this.k);
        }
        return curr;
    }

    private double stabilize(double curr) {
        if (curr * this.k > -this.cutOff) {
            return (float)(-this.cutOff / this.k);
        }
        if (curr * this.k < this.cutOff) {
            return (float)(this.cutOff / this.k);
        }
        return curr;
    }

    @Override
    public double op(double origin, double other) {
        return this.stabilize(origin);
    }

    @Override
    public double op(double origin) {
        return this.stabilize(origin);
    }

    @Override
    public float op(float origin) {
        return this.stabilize(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return this.stabilize(origin);
    }

    private IComplexNumber stabilize(IComplexNumber c) {
        double realMin = 1.1755E-38f;
        double cutOff = FastMath.log((double)realMin);
        double curr = c.realComponent().doubleValue();
        if (curr * this.k > -cutOff) {
            return Nd4j.createDouble(-cutOff / this.k, c.imaginaryComponent().doubleValue());
        }
        if (curr * this.k < cutOff) {
            return Nd4j.createDouble(cutOff / this.k, c.imaginaryComponent().doubleValue());
        }
        return c;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.k};
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Stabilize(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.k);
        }
        return new Stabilize(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.k);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Stabilize(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.k);
        }
        return new Stabilize(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.k);
    }
}

