/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator.cache;

import java.io.File;
import java.nio.file.Path;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.cache.DataSetCache;
import org.nd4j.linalg.dataset.api.iterator.cache.InFileDataSetCache;
import org.nd4j.linalg.dataset.api.iterator.cache.InMemoryDataSetCache;

public class InFileAndMemoryDataSetCache
implements DataSetCache {
    private InFileDataSetCache fileCache;
    private InMemoryDataSetCache memoryCache;

    public InFileAndMemoryDataSetCache(File cacheDirectory) {
        this.fileCache = new InFileDataSetCache(cacheDirectory);
        this.memoryCache = new InMemoryDataSetCache();
    }

    public InFileAndMemoryDataSetCache(Path cacheDirectory) {
        this(cacheDirectory.toFile());
    }

    public InFileAndMemoryDataSetCache(String cacheDirectory) {
        this(new File(cacheDirectory));
    }

    @Override
    public boolean isComplete(String namespace) {
        return this.fileCache.isComplete(namespace) || this.memoryCache.isComplete(namespace);
    }

    @Override
    public void setComplete(String namespace, boolean value) {
        this.fileCache.setComplete(namespace, value);
        this.memoryCache.setComplete(namespace, value);
    }

    @Override
    public DataSet get(String key) {
        DataSet dataSet = null;
        if (this.memoryCache.contains(key)) {
            dataSet = this.memoryCache.get(key);
            if (!this.fileCache.contains(key)) {
                this.fileCache.put(key, dataSet);
            }
        } else if (this.fileCache.contains(key)) {
            dataSet = this.fileCache.get(key);
            if (!this.memoryCache.contains(key)) {
                this.memoryCache.put(key, dataSet);
            }
        }
        return dataSet;
    }

    @Override
    public void put(String key, DataSet dataSet) {
        this.fileCache.put(key, dataSet);
        this.memoryCache.put(key, dataSet);
    }

    @Override
    public boolean contains(String key) {
        return this.memoryCache.contains(key) || this.fileCache.contains(key);
    }
}

