/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GemvParameters {
    private int m;
    private int n;
    private int lda;
    private int incx;
    private int incy;
    private INDArray a;
    private INDArray x;
    private INDArray y;
    private char aOrdering = (char)78;

    public GemvParameters(INDArray a, INDArray x, INDArray y) {
        a = this.copyIfNecessary(a);
        x = this.copyIfNecessaryVector(x);
        this.a = a;
        this.x = x;
        this.y = y;
        if (a.ordering() == 'f' && a.isMatrix()) {
            this.m = a.rows();
            this.n = a.columns();
            this.lda = a.rows();
        } else if (a.ordering() == 'c' && a.isMatrix()) {
            this.m = a.columns();
            this.n = a.rows();
            this.lda = a.columns();
            this.aOrdering = (char)84;
        } else {
            this.m = a.rows();
            this.n = a.columns();
            this.lda = a.size(0);
        }
        this.incx = x.isColumnVector() ? x.stride(0) : x.stride(1);
        this.incy = y.elementWiseStride();
        if (x instanceof IComplexNDArray) {
            this.incx /= 2;
        }
        if (y instanceof IComplexNDArray) {
            this.incy /= 2;
        }
    }

    private INDArray copyIfNecessary(INDArray arr) {
        if (arr.ordering() == 'c' && (arr.stride(0) != arr.size(1) || arr.stride(1) != 1)) {
            return arr.dup();
        }
        if (arr.ordering() == 'f' && (arr.stride(0) != 1 || arr.stride(1) != arr.size(0))) {
            return arr.dup();
        }
        if (arr.elementWiseStride() < 1) {
            return arr.dup();
        }
        return arr;
    }

    private INDArray copyIfNecessaryVector(INDArray vec) {
        if (vec.offset() != 0) {
            return vec.dup();
        }
        return vec;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getLda() {
        return this.lda;
    }

    public int getIncx() {
        return this.incx;
    }

    public int getIncy() {
        return this.incy;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getX() {
        return this.x;
    }

    public INDArray getY() {
        return this.y;
    }

    public char getAOrdering() {
        return this.aOrdering;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setLda(int lda) {
        this.lda = lda;
    }

    public void setIncx(int incx) {
        this.incx = incx;
    }

    public void setIncy(int incy) {
        this.incy = incy;
    }

    public void setA(INDArray a) {
        this.a = a;
    }

    public void setX(INDArray x) {
        this.x = x;
    }

    public void setY(INDArray y) {
        this.y = y;
    }

    public void setAOrdering(char aOrdering) {
        this.aOrdering = aOrdering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GemvParameters)) {
            return false;
        }
        GemvParameters other = (GemvParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getM() != other.getM()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getLda() != other.getLda()) {
            return false;
        }
        if (this.getIncx() != other.getIncx()) {
            return false;
        }
        if (this.getIncy() != other.getIncy()) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$x = this.getX();
        INDArray other$x = other.getX();
        if (this$x == null ? other$x != null : !this$x.equals(other$x)) {
            return false;
        }
        INDArray this$y = this.getY();
        INDArray other$y = other.getY();
        if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
            return false;
        }
        return this.getAOrdering() == other.getAOrdering();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GemvParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getM();
        result = result * 59 + this.getN();
        result = result * 59 + this.getLda();
        result = result * 59 + this.getIncx();
        result = result * 59 + this.getIncy();
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 43 : $a.hashCode());
        INDArray $x = this.getX();
        result = result * 59 + ($x == null ? 43 : $x.hashCode());
        INDArray $y = this.getY();
        result = result * 59 + ($y == null ? 43 : $y.hashCode());
        result = result * 59 + this.getAOrdering();
        return result;
    }

    public String toString() {
        return "GemvParameters(m=" + this.getM() + ", n=" + this.getN() + ", lda=" + this.getLda() + ", incx=" + this.getIncx() + ", incy=" + this.getIncy() + ", a=" + this.getA() + ", x=" + this.getX() + ", y=" + this.getY() + ", aOrdering=" + this.getAOrdering() + ")";
    }
}

