/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.Ones;
import org.nd4j.linalg.util.LinAlgExceptions;

public abstract class BaseTransformOp
extends BaseOp
implements TransformOp {
    public BaseTransformOp(INDArray x, INDArray z) {
        super(x, z);
        LinAlgExceptions.assertSameLength(x, z);
        LinAlgExceptions.assertSameShape(x, z);
    }

    public BaseTransformOp() {
    }

    public BaseTransformOp(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public BaseTransformOp(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        if (y != null) {
            LinAlgExceptions.assertSameLength(x, y);
        }
        LinAlgExceptions.assertSameLength(x, z);
    }

    public BaseTransformOp(INDArray x) {
        super(x);
    }

    @Override
    public TransformOp derivative() {
        return new Ones(this.x, this.y, this.z, this.n);
    }
}

