/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.EpsilonNotEquals;
import org.nd4j.linalg.indexing.conditions.EqualsCondition;
import org.nd4j.linalg.indexing.conditions.GreaterThan;
import org.nd4j.linalg.indexing.conditions.GreaterThanOrEqual;
import org.nd4j.linalg.indexing.conditions.IsInfinite;
import org.nd4j.linalg.indexing.conditions.IsNaN;
import org.nd4j.linalg.indexing.conditions.LessThan;
import org.nd4j.linalg.indexing.conditions.LessThanOrEqual;
import org.nd4j.linalg.indexing.conditions.NotEqualsCondition;

public class Conditions {
    public static Condition isInfinite() {
        return new IsInfinite();
    }

    public static Condition isNan() {
        return new IsNaN();
    }

    public static Condition epsEquals(IComplexNumber value) {
        return new EqualsCondition(value);
    }

    public static Condition epsNotEquals(Number value) {
        return new EpsilonNotEquals(value);
    }

    public static Condition epsEquals(Number value) {
        return new EqualsCondition(value);
    }

    public static Condition equals(IComplexNumber value) {
        return new EqualsCondition(value);
    }

    public static Condition equals(Number value) {
        return new EqualsCondition(value);
    }

    public static Condition notEquals(Number value) {
        return new NotEqualsCondition(value);
    }

    public static Condition greaterThan(IComplexNumber value) {
        return new GreaterThan(value);
    }

    public static Condition greaterThan(Number value) {
        return new GreaterThan(value);
    }

    public static Condition lessThan(IComplexNumber value) {
        return new GreaterThan(value);
    }

    public static Condition lessThan(Number value) {
        return new LessThan(value);
    }

    public static Condition lessThanOrEqual(IComplexNumber value) {
        return new LessThanOrEqual(value);
    }

    public static Condition lessThanOrEqual(Number value) {
        return new LessThanOrEqual(value);
    }

    public static Condition greaterThanOrEqual(IComplexNumber value) {
        return new GreaterThanOrEqual(value);
    }

    @Deprecated
    public static Condition greaterThanOEqual(Number value) {
        return new GreaterThanOrEqual(value);
    }

    public static Condition greaterThanOrEqual(Number value) {
        return new GreaterThanOrEqual(value);
    }
}

