/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.nd4j.linalg.factory.Nd4j;

public class DeviceLocal<T> {
    private Map<Integer, T> backingMap = new ConcurrentHashMap<Integer, T>();
    private List<ReentrantReadWriteLock> locksMap = new ArrayList<ReentrantReadWriteLock>();

    public DeviceLocal() {
        int numDevices = Nd4j.getAffinityManager().getNumberOfDevices();
        for (int i = 0; i < numDevices; ++i) {
            this.locksMap.add(new ReentrantReadWriteLock());
        }
    }

    @Nullable
    public T get() {
        return this.get(Nd4j.getAffinityManager().getDeviceForCurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get(int deviceId) {
        try {
            this.locksMap.get(deviceId).readLock().lock();
            T t = this.backingMap.get(deviceId);
            return t;
        }
        finally {
            this.locksMap.get(deviceId).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int deviceId, T object) {
        try {
            this.locksMap.get(deviceId).writeLock().lock();
            this.backingMap.put(deviceId, object);
        }
        finally {
            this.locksMap.get(deviceId).writeLock().unlock();
        }
    }

    public void set(T object) {
        this.set(Nd4j.getAffinityManager().getDeviceForCurrentThread(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        try {
            this.locksMap.get(deviceId).writeLock().lock();
            this.backingMap.remove(deviceId);
        }
        finally {
            this.locksMap.get(deviceId).writeLock().unlock();
        }
    }
}

