/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMax;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class ActivationSoftmax
extends BaseActivationFunction {
    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        Nd4j.getExecutioner().execAndReturn(new SoftMax(in));
        return in;
    }

    @Override
    public Pair<INDArray, INDArray> backprop(INDArray in, INDArray epsilon) {
        INDArray out = Nd4j.getExecutioner().execAndReturn(new SoftMax(in));
        INDArray x = out.mul(epsilon).sum(1);
        INDArray dLdz = out.mul(epsilon.subColumnVector(x));
        return new Pair((Object)dLdz, null);
    }

    public String toString() {
        return "softmax";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationSoftmax)) {
            return false;
        }
        ActivationSoftmax other = (ActivationSoftmax)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationSoftmax;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

