/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.factory;

import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.LossFunction;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.factory.OpFactory;
import org.nd4j.linalg.api.ops.impl.accum.Max;
import org.nd4j.linalg.api.ops.impl.accum.Min;
import org.nd4j.linalg.api.ops.impl.accum.Mmul;
import org.nd4j.linalg.api.ops.impl.accum.Norm1;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.api.ops.impl.accum.Prod;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.accum.TensorMmul;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.accum.distances.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.indexaccum.IAMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMin;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMax;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMin;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarRemainder;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.shape.Permute;
import org.nd4j.linalg.api.ops.impl.shape.Reshape;
import org.nd4j.linalg.api.ops.impl.shape.Transpose;
import org.nd4j.linalg.api.ops.impl.transforms.ACos;
import org.nd4j.linalg.api.ops.impl.transforms.ASin;
import org.nd4j.linalg.api.ops.impl.transforms.ATan;
import org.nd4j.linalg.api.ops.impl.transforms.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.Ceil;
import org.nd4j.linalg.api.ops.impl.transforms.Cos;
import org.nd4j.linalg.api.ops.impl.transforms.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.Floor;
import org.nd4j.linalg.api.ops.impl.transforms.HardSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.HardSigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Identity;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Log;
import org.nd4j.linalg.api.ops.impl.transforms.LogSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.MaxOut;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.Pow;
import org.nd4j.linalg.api.ops.impl.transforms.RationalTanh;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.Round;
import org.nd4j.linalg.api.ops.impl.transforms.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Sign;
import org.nd4j.linalg.api.ops.impl.transforms.Sin;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.Sqrt;
import org.nd4j.linalg.api.ops.impl.transforms.Stabilize;
import org.nd4j.linalg.api.ops.impl.transforms.Step;
import org.nd4j.linalg.api.ops.impl.transforms.Tanh;
import org.nd4j.linalg.api.ops.impl.transforms.TanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.TimesOneMinus;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SubOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DefaultOpFactory
implements OpFactory {
    private Map<String, Class<? extends Op>> opClazzes = new HashMap<String, Class<? extends Op>>();

    public DefaultOpFactory() {
        Reflections f = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().include(FilterBuilder.prefix((String)"org.nd4j")).exclude("^(?!.*\\.class$).*$").exclude("^(?!org\\.nd4j\\.linalg\\.api\\.ops).*")).setUrls(ClasspathHelper.forPackage((String)"org.nd4j", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}));
        Set clazzes = f.getSubTypesOf(Op.class);
        for (Class clazz : clazzes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) continue;
            try {
                this.opClazzes.put(((Op)clazz.newInstance()).name(), clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Op createShape(String name, INDArray x, INDArray z) {
        switch (name) {
            case "transpose": {
                return new Transpose(x, z);
            }
            case "reshape": {
                return new Reshape(x, z);
            }
            case "permute": {
                return new Permute(x, z);
            }
        }
        throw new IllegalArgumentException("Illegal name for create shape op" + name);
    }

    @Override
    public LossFunction createLossFunction(String name, INDArray x, INDArray y) {
        Class<? extends Op> clazz = this.opClazzes.get(name);
        try {
            Constructor<? extends Op> constructor = clazz.getDeclaredConstructor(INDArray.class, INDArray.class);
            Op create = constructor.newInstance(x, y);
            return (LossFunction)create;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal op " + name);
        }
    }

    @Override
    public Accumulation createAccum(String name, INDArray x) {
        return this.createAccum(name, x, null, x, null);
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y, INDArray z) {
        return this.createAccum(name, x, y, z, null);
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        Op ret = null;
        switch (name) {
            case "sum": {
                ret = new Sum(x, y, z, x.length());
                break;
            }
            case "max": {
                ret = new Max(x, y, z, x.length());
                break;
            }
            case "min": {
                ret = new Min(x, y, z, x.length());
                break;
            }
            case "norm1": {
                ret = new Norm1(x, y, z, x.length());
                break;
            }
            case "norm2": {
                ret = new Norm2(x, y, z, x.length());
                break;
            }
            case "prod": {
                ret = new Prod(x, y, z, x.length());
                break;
            }
            case "std": {
                ret = new StandardDeviation(x, y, z, x.length(), (Boolean)extraArgs[0]);
                break;
            }
            case "var": {
                ret = new Variance(x, y, z, x.length(), (Boolean)extraArgs[0]);
                break;
            }
            case "euclidean": {
                ret = new EuclideanDistance(x, y, z, x.length());
                break;
            }
            case "cosine": 
            case "cosinesimilarity": {
                ret = new CosineSimilarity(x, y, z, x.length());
                break;
            }
            case "manhattan": {
                ret = new ManhattanDistance(x, y, z, x.length());
                break;
            }
            case "mmul": {
                ret = new Mmul(x, y, z, x.length());
                break;
            }
            case "tensorMmul": {
                ret = new TensorMmul(x, y, z, (int[][])extraArgs[0]);
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Illegal operation name " + name);
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y) {
        return this.createAccum(name, x, y, x, null);
    }

    @Override
    public IndexAccumulation createIndexAccum(String opName, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        Op ret = null;
        switch (opName) {
            case "iamax": {
                ret = new IAMax(x, y);
                break;
            }
            case "imax": {
                ret = new IMax(x, y);
                break;
            }
            case "imin": {
                ret = new IMin(x, y);
            }
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public IndexAccumulation createIndexAccum(String name, INDArray x) {
        return this.createIndexAccum(name, x, null, x, null);
    }

    @Override
    public IndexAccumulation createIndexAccum(String name, INDArray x, INDArray y) {
        return this.createIndexAccum(name, x, y, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y) {
        return this.createTransform(name, x, y, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x) {
        return this.createTransform(name, x, null, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, Object[] extraArgs) {
        return this.createTransform(name, x, null, x, extraArgs);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y, INDArray z) {
        return this.createTransform(name, x, y, z, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        BaseTransformOp op = null;
        switch (name) {
            case "relu": {
                op = new RectifedLinear(x, z, x.length(), extraArgs == null || extraArgs[0] == null ? 0.0 : (Double)extraArgs[0]);
                break;
            }
            case "step": {
                op = new Step(x, y, z, x.length(), extraArgs == null || extraArgs[0] == null ? 0.0 : (Double)extraArgs[0]);
                break;
            }
            case "abs": {
                op = new Abs(x, z);
                break;
            }
            case "acos": {
                op = new ACos(x, z);
                break;
            }
            case "asin": {
                op = new ASin(x, z);
                break;
            }
            case "atan": {
                op = new ATan(x, z);
                break;
            }
            case "ceil": {
                op = new Ceil(x, z);
                break;
            }
            case "cos": {
                op = new Cos(x, z);
                break;
            }
            case "exp": {
                op = new Exp(x, z);
                break;
            }
            case "elu": {
                op = new ELU(x, z);
                break;
            }
            case "floor": {
                op = new Floor(x, z);
                break;
            }
            case "hardtanh": {
                op = new HardTanh(x, z);
                break;
            }
            case "hardsigmoid": {
                op = new HardSigmoid(x, z);
                break;
            }
            case "identity": {
                op = new Identity(x, z);
                break;
            }
            case "leakyrelu": {
                op = new LeakyReLU(x, z);
                break;
            }
            case "log": {
                op = new Log(x, z);
                break;
            }
            case "logsoftmax": {
                op = new LogSoftMax(x, z);
                break;
            }
            case "maxout": {
                op = new MaxOut(x, z);
                break;
            }
            case "negative": {
                op = new Negative(x, z);
                break;
            }
            case "pow": {
                op = new Pow(x, z, (Double)extraArgs[0]);
                break;
            }
            case "round": {
                op = new Round(x, z);
                break;
            }
            case "sigmoid": {
                op = new Sigmoid(x, z);
                break;
            }
            case "sign": {
                op = new Sign(x, z);
                break;
            }
            case "sin": {
                op = new Sin(x, z);
                break;
            }
            case "softsign": {
                op = new SoftSign(x, z);
                break;
            }
            case "sqrt": {
                op = new Sqrt(x, z);
                break;
            }
            case "stabilize": {
                op = new Stabilize(x, z, 1.0);
                break;
            }
            case "tanh": {
                op = new Tanh(x, z);
                break;
            }
            case "rationaltanh": {
                op = new RationalTanh(x, z);
                break;
            }
            case "timesoneminus": {
                op = new TimesOneMinus(x, z);
                break;
            }
            case "softmax": {
                op = new SoftMax(x, z);
                break;
            }
            case "softplus": {
                op = new SoftPlus(x, z);
                break;
            }
            case "cube": {
                op = new Cube(x, z);
                break;
            }
            case "sigmoidderivative": {
                op = new SigmoidDerivative(x, z);
                break;
            }
            case "hard_sigmoidderivative": {
                op = new HardSigmoidDerivative(x, z);
                break;
            }
            case "hardtanhderivative": {
                op = new HardTanhDerivative(x, z);
                break;
            }
            case "tanhderivative": {
                op = new TanhDerivative(x, z);
                break;
            }
            case "leakyreluderivative": {
                op = new LeakyReLUDerivative(x, z);
                break;
            }
            case "mul": {
                op = new MulOp(x, y, z);
                break;
            }
            case "add": {
                op = new AddOp(x, y, z);
                break;
            }
            case "sub": {
                op = new SubOp(x, y, z);
                break;
            }
            case "div": {
                op = new DivOp(x, y, z);
                break;
            }
            case "rdiv": {
                op = new RDivOp(x, y, z);
                break;
            }
            case "rsub": {
                op = new RSubOp(x, y, z);
                break;
            }
            case "neg": {
                op = new Negative(x, z);
                break;
            }
            default: {
                throw new ND4JIllegalStateException("No op found " + name);
            }
        }
        op.setExtraArgs(extraArgs);
        return op;
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, double scalar) {
        return this.createScalarTransform(name, x, y, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, double scalar) {
        return this.createScalarTransform(name, x, null, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, Object[] extraArgs, double scalar) {
        return this.createScalarTransform(name, x, null, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, INDArray z, double scalar) {
        return this.createScalarTransform(name, x, y, z, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs, double scalar) {
        Op ret = null;
        switch (name) {
            case "add_scalar": {
                ret = new ScalarAdd(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "sub_scalar": {
                ret = new ScalarSubtraction(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "mul_scalar": {
                ret = new ScalarMultiplication(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "div_scalar": {
                ret = new ScalarDivision(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "equals_scalar": {
                ret = new ScalarEquals(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "notequals_scalar": {
                ret = new ScalarNotEquals(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "fmod_scalar": {
                ret = new ScalarFMod(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "max_scalar": {
                ret = new ScalarMax(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "min_scalar": {
                ret = new ScalarMin(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "greaterthan_scalar": {
                ret = new ScalarGreaterThan(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "greaterthanorequal_scalar": {
                ret = new ScalarGreaterThanOrEqual(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "lessthan_scalar": {
                ret = new ScalarLessThan(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "lessthanorequal_scalar": {
                ret = new ScalarLessThanOrEqual(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "remainder_scalar": {
                ret = new ScalarRemainder(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "rdiv_scalar": {
                ret = new ScalarReverseDivision(x, y, z, (long)x.length(), scalar);
                break;
            }
            case "rsub_scalar": {
                ret = new ScalarReverseSubtraction(x, y, z, (long)x.length(), scalar);
            }
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, INDArray z, int ... dimension) {
        return this.createBroadcastOp(name, x, y, z, (Object[])null, dimension);
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs, int ... dimension) {
        Op broadcastOp = null;
        switch (name) {
            case "broadcastadd": {
                broadcastOp = new BroadcastAddOp(x, y, z, dimension);
                break;
            }
            case "broadcastsub": {
                broadcastOp = new BroadcastSubOp(x, y, z, dimension);
                break;
            }
            case "broadcastmul": {
                broadcastOp = new BroadcastMulOp(x, y, z, dimension);
                break;
            }
            case "broadcastdiv": {
                broadcastOp = new BroadcastDivOp(x, y, z, dimension);
                break;
            }
            case "broadcastrsub": {
                broadcastOp = new BroadcastRSubOp(x, y, z, dimension);
                break;
            }
            case "broadcastrdiv": {
                broadcastOp = new BroadcastRDivOp(x, y, z, dimension);
                break;
            }
            case "broadcastcopy": {
                broadcastOp = new BroadcastCopyOp(x, y, z, dimension);
            }
        }
        broadcastOp.setExtraArgs(extraArgs);
        return broadcastOp;
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, int ... dimension) {
        return this.createBroadcastOp(name, x, y, x, (Object[])null, dimension);
    }
}

